/*
 * lxdata.h
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxdata_H__
#define __LIBx1f4_lxdata_H__

#include <dt.h>
#include <nl.h>

/*
 * error definitions
 */
#define X1f4_LXDATE_FREE_ERROR		-2
#define X1f4_LXDATE_LINK_ERROR		-3
#define X1f4_LXDATE_MODE_ERROR		-4

/*
 * generation flag definitions
 */
#define X1f4_LXDATE_CODELINK		(1L << 0)
#define X1f4_LXDATE_EVERLINK		(1L << 1)
#define X1f4_LXDATE_RESOURCE		(1L << 2)
#define X1f4_LXDATE_TEXTFLAT		(1L << 3)

#if !defined __x1f4_function_type_defined__
typedef struct x1f4_function_type {
    const char *name;
    int (*function) (void *, void *, void **), type;
    const int *args;
    unsigned count, flags, length;
} x1f4_function_type;
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_function_type_defined__
# define __x1f4_function_type_defined__
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
typedef struct x1f4_linetext_type {
    struct x1f4_function_type function;
    const void *context;
} x1f4_linetext_type;
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
# define __x1f4_linetext_type_defined__
#endif				/* !__x1f4_linetext_type_defined__ */

typedef struct x1f4_dxdata_type {
    char *string;
    unsigned call, length;
} x1f4_dxdata_type;

typedef struct x1f4_lxdata_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int type;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
} x1f4_lxdata_type;

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *context;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

extern int x1f4_copy_lxdata
    (void *, void *, void **, const void *,
     const struct x1f4_nodelink_type *);
extern int x1f4_dset_lxdata(void *, const struct x1f4_datatype_type **);
extern int x1f4_even_lxdata(void *, void *, void *, const void *);
extern int x1f4_fare_lxdata
    (void *, void *, void **, const void *, const struct x1f4_nodelink_type *);
extern int x1f4_fini_lxdata(void **);
extern int x1f4_flat_lxdata(void *, void **);
extern int x1f4_free_lxdata
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_fset_lxdata(void *, const struct x1f4_linetext_type **);
extern int x1f4_high_dxdata(void *, struct x1f4_dxdata_type *);
extern int x1f4_hold_lxdata(void *, struct x1f4_trans_type *);
extern int x1f4_init_lxdata
    (void **, unsigned, const struct x1f4_lxdata_type *);
extern int x1f4_jack_dxdata
    (void *, struct x1f4_dxdata_type *, const void *, unsigned);
extern int x1f4_line_lxdata(void *, void **);
extern int x1f4_link_lxdata(void *, void **);
extern int x1f4_node_lxdata
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_post_lxdata
    (void *, void **, const struct x1f4_nodelink_type *);
extern int x1f4_rule_lxdata
    (void *, void *, unsigned, unsigned, void *);

#endif				/* __LIBx1f4_lxdata_H__ */
