/*
 * lxdata-size.h
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxdata_size_H__
#define __LIBx1f4_lxdata_size_H__

#include <lxdata-config.h>

#if __LINEAR_DATA__
# define case_size(___s)		((___s) & 15)
#else
# define case_size(___s) \
    (((___s) & ((___s) - 1)) | ((___s) & 15))
#endif				/* __LINEAR_DATA__ */

#if __LINEAR_DATA__
# define near_size(___s)		((___s) + 16)
#else
# define near_size(___s)		((___s) << 1)
#endif				/* __LINEAR_DATA__ */

#if __LINEAR_DATA__
#else
# define ___data_deck2(___t, ___s) \
    {									      \
	unsigned a;							      \
									      \
	a = (___s);							      \
									      \
	if (a & (a - 1)) {						      \
	    a |= a >> 001;						      \
	    a |= a >> 002;						      \
	    a |= a >> 004;						      \
	    a |= a >> 010;						      \
	    a |= a >> 020;						      \
									      \
	    a++;							      \
	}								      \
									      \
	(___t) = a;							      \
    }
#endif				/* __LINEAR_DATA__ */

#if __LINEAR_DATA__
# define text_size(___t, ___s) \
    ((___t) = ((___s) + 15) & ~15)
#else
# define text_size(___t, ___s)		___data_deck2((___t), (___s))
#endif				/* __LINEAR_DATA__ */

#endif				/* __LIBx1f4_lxdata_size_H__ */
