/*
 * lxdata-p.s.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_DATA(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define lock_exdata(data) \
    (data)

int
_libx1f4i0_lxdata_s_pending(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxdata_type *dxdata_data, *dxdata_text;
	unsigned call;

	dxdata_data = I_DATA(input[0]);
	dxdata_text = I_DATA(input[1]);

	lock_exdata(dxdata_text)->call++;

	call = dxdata_data->call;
	call--;
	if (call) {
	    dxdata_data->call = call;

	    status = 0;
	} else {
	    status = _libx1f4i0_lxdata_side_data(context, dxdata_data);
	    if (status) {
		lock_exdata(dxdata_text)->call--;
		_libx1f4i0_lxdata_link_data(context, input[0]);
		if (1) {
		    break;
		}
	    } else {
	    }
	}

	l_DATA(dxdata_text, input[0]);
	l_DATA(dxdata_text, output);
    } while (0);

    return status;
}
