/*
 * lxdata-p.l.c
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lstring.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxdata_l_pending(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE pick;
	X1f4_E4_C_TEXT text;
	struct dxdata_type *dxdata_data;
	unsigned c, size;

	dxdata_data = I_DATA(input[0]);

	size = dxdata_data->length + 1;

	pick = I_MODE(input[1]);

	if (pick < 0) {
	    if ((X1f4_E4_C_MODE) size < -pick) {
		status = _libx1f4i0_lxdata_stat_deck(context, size, -pick);
		if (1) {
		    break;
		}
	    } else {
		pick = size + pick;
	    }
	} else {
	    if (pick < size) {
	    } else {
		status = _libx1f4i0_lxdata_stat_deck(context, size, pick);
		if (1) {
		    break;
		}
	    }
	}

	status = 0;

	size--;
	size -= pick;

	text = I_TEXT(input[2]);

	c = *(unsigned char *) text;
	if (c) {
	    if (*(text + 1)) {
		unsigned side[8];

		side[0] = ~0;
		side[1] = ~0;
		side[2] = ~0;
		side[3] = ~0;
		side[4] = ~0;
		side[5] = ~0;
		side[6] = ~0;
		side[7] = ~0;

		do {
		    side[c >> 5] &= ~(1 << (c & 31));
		    text++;
		    c = *(unsigned char *) text;
		} while (c);

		l_MODE(_libx1f4i0_side_lstring
		       (dxdata_data->string + pick, size, side), output);
	    } else {
		unsigned look;

		_libx1f4i0_lock_lstring
		    (dxdata_data->string + pick, size, c, &look);

		l_MODE(look, output);
	    }
	} else {
	    l_MODE(size, output);
	}
    } while (0);

    return status;
}
