/*
 * lxdata-p.c.c
 * Copyright (C) 2008-2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxdata_c_pending(void *context, void *output, void **input)
{
    int status;
    struct dxdata_type *dxdata_data, *dxdata_text;

    dxdata_data = I_DATA(input[0]);

    dxdata_text = I_DATA(input[1]);

    if (dxdata_text == dxdata_data) {
	status = 0;
    } else {
	status = _libx1f4i0_lxdata_bill_text
	    (context, dxdata_data, dxdata_text->length, dxdata_text->string);
    }

    return status;
}
