/*
 * lxdata-l.f.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

int
_libx1f4i0_lxdata_f_logique(void *context, void *output, void **input)
{
    int status;

    do {
	char *cast;
	struct dxdata_type *dxdata_data;
	unsigned mode, size;

	dxdata_data = I_DATA(input[0]);

	cast = I_TEXT(input[1]);

	mode = strlen(cast);

	size = dxdata_data->length;

	if (mode) {
	    unsigned copy, rate;
	    void *text;

	    rate = size + mode;

	    if (rate < 16) {
		copy = 16;
	    } else {
		text_size(copy, rate);
	    }

	    if (size) {
		int tier;
		unsigned call, lift;

		text = dxdata_data->string;

		tier = cast < (char *) text || (char *) text + size < cast;
		if (tier) {
		    lift = 0;
		} else {
		    lift = cast - (char *) text;
		}

		if (size < 16) {
		    call = 16;
		} else {
		    text_size(call, size);
		}
		if (copy ^ call) {
		    struct lxdata_type *lxdata_data;

		    lxdata_data = context;

		    status = lxdata_data->link_m.mode
			(lxdata_data->link_m.data, &text, copy + 1);
		    if (status) {
			status = _libx1f4i0_lxdata_stat_mode(lxdata_data);
			if (1) {
			    break;
			}
		    }
		} else {
		    status = 0;
		}

		if (tier) {
		} else {
		    char *slip;

		    dxdata_data->length = rate;
		    dxdata_data->string = text;

		    slip = text;

		    slip[rate] = 0;

		    memcpy(slip + size, slip + lift, mode);

		    if (1) {
			break;
		    }
		}
	    } else {
		struct lxdata_type *lxdata_data;

		lxdata_data = context;

		status = lxdata_data->link_m.link
		    (lxdata_data->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_link(lxdata_data);
		    if (1) {
			break;
		    }
		}
	    }

	    dxdata_data->length = rate;
	    dxdata_data->string = text;

	    memcpy((char *) text + size, cast, mode + 1);
	} else {
	    status = 0;
	}
    } while (0);

    return status;
}
