/*
 * lxdata-l.a.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdata-config.h>

#include <string.h>

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

int
_libx1f4i0_lxdata_a_logique(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxdata_type *dxdata_data;
	unsigned size;
	void *text;

	dxdata_data = I_DATA(input[0]);

	size = dxdata_data->length;

	text = dxdata_data->string;

	if (size) {
	    if (case_size(size)) {
		status = 0;
	    } else {
		struct lxdata_type *lxdata_data;

		lxdata_data = context;

		status = lxdata_data->link_m.mode
		    (lxdata_data->link_m.data, &text, near_size(size) + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_mode(lxdata_data);
		    if (1) {
			break;
		    }
		} else {
		    dxdata_data->string = text;
		}
	    }
	} else {
	    if (1) {
		struct lxdata_type *lxdata_data;

		lxdata_data = context;

		status = lxdata_data->link_m.link
		    (lxdata_data->link_m.data, &text, 17);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_link(lxdata_data);
		    if (1) {
			break;
		    }
		} else {
		    dxdata_data->string = text;
		}
	    }
	}

	if (1) {
	    char *copy;

	    copy = text;
	    copy[size] = I_MODE(input[1]);
	    size++;
	    copy[size] = 0;
	}

	dxdata_data->length = size;
    } while (0);

    return status;
}
