/*
 * lxdata-f.r.c
 * Copyright (C) 2008-2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

int
_libx1f4i0_lxdata_r_forward(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_BILL bill;
	X1f4_E4_C_MODE mode, rule;
	struct dxdata_type *dxdata_data, *dxdata_text;
	unsigned mail, size;

	dxdata_data = I_DATA(input[0]);

	size = dxdata_data->length + 1;

	rule = I_MODE(input[1]);

	if (rule < 0) {
	    if ((X1f4_E4_C_MODE) size < -rule) {
		status = _libx1f4i0_lxdata_stat_deck(context, size, -rule);
		if (1) {
		    break;
		}
	    } else {
		rule = size + rule;
	    }
	} else {
	    if (rule < size) {
	    } else {
		status = _libx1f4i0_lxdata_stat_deck(context, size, rule);
		if (1) {
		    break;
		}
	    }
	}

	dxdata_text = I_DATA(input[2]);

	size = dxdata_text->length;

	mode = I_MODE(input[3]);

	size++;

	if (mode < 0) {
	    if ((X1f4_E4_C_MODE) size < -mode) {
		status = _libx1f4i0_lxdata_stat_deck(context, size, -mode);
		if (1) {
		    break;
		}
	    } else {
		mode = size + mode;
	    }
	} else {
	    if (mode < size) {
	    } else {
		status = _libx1f4i0_lxdata_stat_deck(context, size, mode);
		if (1) {
		    break;
		}
	    }
	}

	size--;

	bill = I_BILL(input[4]);

	mail = size - mode;

	if (bill < mail) {
	} else {
	    bill = mail;
	}

	if (0) {
	} else {
	    status = _libx1f4i0_lxdata_rule_text
		(context, dxdata_data, rule, bill, dxdata_text->string + mode);
	}
    } while (0);

    return status;
}
