/*
 * lxdata-f.p.c
 * Copyright (C) 2008-2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

int
_libx1f4i0_lxdata_p_forward(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE rule;
	X1f4_E4_C_TEXT cast;
	struct dxdata_type *dxdata_data;
	unsigned mine, size;

	dxdata_data = I_DATA(input[0]);

	size = dxdata_data->length;

	rule = I_MODE(input[1]);

	size++;

	if (rule < 0) {
	    if ((X1f4_E4_C_MODE) size < -rule) {
		status = _libx1f4i0_lxdata_stat_deck(context, size, -rule);
		if (1) {
		    break;
		}
	    } else {
		rule = size + rule;
	    }
	} else {
	    if (rule < size) {
	    } else {
		status = _libx1f4i0_lxdata_stat_deck(context, size, rule);
		if (1) {
		    break;
		}
	    }
	}

	cast = I_TEXT(input[2]);

	mine = strlen(cast);

	if (mine) {
	    status = _libx1f4i0_lxdata_rule_data
		(context, dxdata_data, rule, mine, cast);
	} else {
	    status = 0;
	}
    } while (0);

    return status;
}
