/*
 * lxdata-f.n.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_DATA(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxdata_n_forward(void *context, void *output, void **input)
{
    int status;
    struct dxdata_type *dxdata_data;
    unsigned call;

    dxdata_data = I_DATA(input[0]);

    call = dxdata_data->call - 1;
    if (call) {
	void *subtext;

	subtext = context;

	dxdata_data->call = call;

	status = _libx1f4i0_lxdata_line_data(subtext, input[0]);
	if (status) {
	    l_DATA(NULL, input[0]);
	}
    } else {
	status = _libx1f4i0_lxdata_c_logique(context, output, input);
    }

    return status;
}
