/*
 * lxdata-f.i.c
 * Copyright (C) 2008-2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lstring.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxdata_i_forward(void *context, void *output, void **input)
{
    struct dxdata_type *dxdata_data;
    unsigned lock, size;

    dxdata_data = I_DATA(input[0]);

    size = dxdata_data->length;

    _libx1f4i0_lock_lstring
	(dxdata_data->string, size, I_MODE(input[1]), &lock);
    if (lock ^ size) {
	l_MODE(lock, output);
    } else {
	l_MODE(-1, output);
    }

    return 0;
}
