/*
 * lxdata-d.p.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxdata_p_derived(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE mode;
	struct dxdata_type *dxdata_data;
	unsigned size;

	dxdata_data = I_DATA(input[0]);

	mode = I_MODE(input[1]);

	size = dxdata_data->length + 1;

	if (mode < 0) {
	    if ((X1f4_E4_C_MODE) size < -mode) {
		status = _libx1f4i0_lxdata_stat_deck(context, size, -mode);
		if (1) {
		    break;
		}
	    } else {
		mode = size + mode;
	    }
	} else {
	    if (mode < size) {
	    } else {
		status = _libx1f4i0_lxdata_stat_deck(context, size, mode);
		if (1) {
		    break;
		}
	    }
	}

	status = 0;

	l_TEXT(dxdata_data->string + mode, output);
    } while (0);

    return status;
}
