/*
 * lxdata-c.d.c
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ctype.0.h>
#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

extern const char *const x1f4_c1_empty_string;

static void fail_data(unsigned char *, unsigned *, unsigned *);

static void
fail_data(unsigned char *data, unsigned *fail, unsigned *side)
{
    unsigned i;
    unsigned char *text;

    text = data;

    i = *fail;
    for (; i; i--) {
	int c;

	c = *data++;
	if (C_TYPE_X(side, c)) {
	    *text++ = c;
	}
    }

    *text = 0;

    *fail -= data - text;
}


int
_libx1f4i0_lxdata_d_centric(void *context, void *output, void **input)
{
    int status;
    struct dxdata_type *dxdata_data;
    unsigned rate, side[8], size;
    void *text;

    dxdata_data = I_DATA(input[0]);

    size = dxdata_data->length;
    text = dxdata_data->string;

    rate = size;

    side[0] = ~0;
    side[1] = ~0;
    side[2] = ~0;
    side[3] = ~0;
    side[4] = ~0;
    side[5] = ~0;
    side[6] = ~0;
    side[7] = ~0;

    if (1) {
	unsigned c;
	char unsigned *text;

	text = (unsigned char *) I_TEXT(input[1]);

	c = *text;
	while (c) {
	    side[c >> 5] &= ~(1 << (c & 31));
	    c = *++text;
	}
    }

    fail_data(text, &rate, side);

    if (rate == size) {
	status = 0;
    } else {
	if (rate) {
	    unsigned call, copy;

	    if (rate < 16) {
		copy = 16;
	    } else {
		text_size(copy, rate);
	    }
	    if (size < 16) {
		call = 16;
	    } else {
		text_size(call, size);
	    }
	    if (copy ^ call) {
		struct lxdata_type *lxdata_data;

		lxdata_data = context;

		status = lxdata_data->link_m.mode
		    (lxdata_data->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_mode(lxdata_data);
		} else {
		    dxdata_data->length = rate;
		    dxdata_data->string = text;
		}
	    } else {
		status = 0;
	    }
	} else {
	    struct lxdata_type *lxdata_data;

	    lxdata_data = context;

	    status = lxdata_data->link_m.free(lxdata_data->link_m.data, text);
	    if (status) {
		status = _libx1f4i0_lxdata_stat_free(lxdata_data);
	    } else {
		dxdata_data->length = 0;
		dxdata_data->string = (char *) x1f4_c1_empty_string;
	    }
	}
    }

    return status;
}
