/*
 * lxdata-a.p.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

int
x1f4_jack_dxdata(struct lxdata_type *lxdata_data,
		 struct dxdata_type *dxdata_data, const void *cast,
		 unsigned mode)
{
    int status;

    do {
	unsigned size;

	size = dxdata_data->length;

	if (mode) {
	    unsigned copy, rate;
	    void *text;

	    rate = size + mode;

	    if (rate < 16) {
		copy = 16;
	    } else {
		text_size(copy, rate);
	    }

	    if (size) {
		text = dxdata_data->string;

		status = lxdata_data->link_m.mode
		    (lxdata_data->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_mode(lxdata_data);
		    if (1) {
			break;
		    }
		}
	    } else {
		status = lxdata_data->link_m.link
		    (lxdata_data->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_link(lxdata_data);
		    if (1) {
			break;
		    }
		}
	    }

	    dxdata_data->length = rate;
	    dxdata_data->string = text;

	    *((char *) text + rate) = 0;

	    memcpy((char *) text + size, cast, mode);
	} else {
	    status = 0;
	}
    } while (0);

    return status;
}
