/*
 * lxdata-a.e.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <lintegral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define lxdata(lxdata) \
    ((struct lxdata_type *) (lxdata))

int
_libx1f4i0_lxdata_stat_deck(void *lxdata, unsigned size, long mode)
{
    if (size) {
	_libx1f4i0_lxdata_stat_time(lxdata, size, mode);
    } else {
	_libx1f4i0_lxdata_stat_null(lxdata);
    }

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdata_stat_free(void *lxdata)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdata(lxdata)->link_e.data;

	line = lxdata(lxdata)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdata(lxdata)->link_e.push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = lxdata(lxdata)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdata_stat_link(void *lxdata)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdata(lxdata)->link_e.data;

	line = lxdata(lxdata)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdata(lxdata)->link_e.push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = lxdata(lxdata)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdata_stat_mode(void *lxdata)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdata(lxdata)->link_e.data;

	line = lxdata(lxdata)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdata(lxdata)->link_e.push;
	if (push) {
	    status = push(data, "cannot reallocate memory", 24);
	    if (status) {
		break;
	    }
	}

	post = lxdata(lxdata)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdata_stat_null(void *lxdata)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdata(lxdata)->link_e.data;

	line = lxdata(lxdata)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdata(lxdata)->link_e.push;
	if (push) {
	    status = push(data, "empty byte array", 16);
	    if (status) {
		break;
	    }
	}

	post = lxdata(lxdata)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdata_stat_sign(void *lxdata, long mode)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdata(lxdata)->link_e.data;

	line = lxdata(lxdata)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdata(lxdata)->link_e.push;
	if (push) {
	    status = push(data, "negative size indication (", 26);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dlintegral(data, push, mode);
		if (status) {
		    break;
		} else {
		    status = push(data, ")", 1);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxdata(lxdata)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdata_stat_time(void *lxdata, unsigned size, long mode)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxdata(lxdata)->link_e.data;

	line = lxdata(lxdata)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxdata(lxdata)->link_e.push;
	if (push) {
	    status = push(data, "out of valid range (-", 21);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dcardinal(data, push, size);
		if (status) {
		    break;
		} else {
		    status = push(data, " .. ", 4);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_dcardinal(data, push, size - 1);
			if (status) {
			    break;
			} else {
			    status = push(data, ") data index (", 14);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_dlintegral
				    (data, push, mode);
				if (status) {
				    break;
				} else {
				    status = push(data, ")", 1);
				    if (status) {
					break;
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxdata(lxdata)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
