/*
 * lxcast-p.c.c
 * Copyright (C) 2010-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcast-inter.h>
#include <lxcast-types.h>

#define I_CAST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxcast_c_pending(void *context, void *output, void **input)
{
    int status, type;
    struct dxcast_type *dxcast_data;

    dxcast_data = I_CAST(input[0]);

    type = dxcast_data->type;
    if (X1f4_E4_CALL < type) {
	l_MODE(((struct x1f4_linetext_type *)
		I_USER(&dxcast_data->data))->function.count, output);
	status = 0;
    } else {
	status = _libx1f4i0_lxcast_stat_call(context, type);
    }

    return status;
}
