/*
 * lxcast-l.t.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcall.h>
#include <lxcast-inter.h>
#include <lxcast-types.h>

#define I_CAST(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define dxcast(cast) \
    ((struct dxcast_type *) (cast))

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxcast_t_logique(void *context, void *output, void **input)
{
    const char *name;
    int status = 0, type;
    struct dxcast_type *dxcast_data;
    struct lxcast_type *lxcast_data;

    name = x1f4_c1_empty_string;

    dxcast_data = I_CAST(input[0]);

    lxcast_data = context;

    type = dxcast_data->type;

#if 0
    if (1) {
	struct lxtext_type *lxtext_data;
	unsigned i;

	lxtext_data = lxcast_data->link_f.text;
	i = ((struct lxmiss_type *) (void *) lxtext_data - 1)->data.miss;
	for (; i; i--) {
	    if (lxtext_data->nodetype.code == type) {
		name = lxtext_data->nodetype.name;
		if (1) {
		    break;
		}
	    } else {
		lxtext_data++;
	    }
	}

	l_TEXT((char *) name, output);
    }
#else
    if (1) {
	struct trans_type trans;

	trans.data = lxcast_data->link_v.data;
	trans.free = lxcast_data->link_v.free;
	trans.link = lxcast_data->link_v.link;
	trans.mode = lxcast_data->link_v.mode;

	status = _libx1f4i0_lxcall_line_type
	    (&name, type, lxcast_data->trap_e.eelookup_data, &trans);
	if (status) {
	    status = _libx1f4i0_lxcast_stat_link(lxcast_data);
	} else {
	    l_TEXT((char *) name, output);
	}
    }
#endif				/* 0 */

    return status;
}
