/*
 * lxcast-i.w.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxcast-inter.h>
#include <lxcast-types.h>

#define lxcast(lxcast) \
    ((struct lxcast_type *) (lxcast))

int
x1f4_lead_lxcast(void *subtext, void **data)
{
    int status = 0, type;
    struct dxcast_type *dxcast_data;

    dxcast_data = *data;

    type = dxcast_data->call;

    if (type) {
	dxcast_data->call = type + 1;
    } else {
	struct lxtext_type *lxtext_data;
	unsigned i;

	type = dxcast_data->type;

	dxcast_data->call = 1;

	lxtext_data = lxcast(subtext)->link_f.text;
	i = ((struct lxmiss_type *) (void *) lxtext_data - 1)->data.miss;
	for (; i; i--) {
	    if (lxtext_data->nodetype.code == type) {
		int (*lead) (void *, void **);

		lead = lxtext_data->nodetype.lead;
		if (lead) {
		    status = lead
			(lxtext_data->nodetype.context,
			 (void *) &dxcast_data->data);
		} else {
		    if (X1f4_E4_LAST < type && type < X1f4_E4_CALL) {
			i = 0;
		    }
		}

		break;
	    } else {
		lxtext_data++;
	    }
	}

	if (i) {
	} else {
	    if (X1f4_E4_LAST < type && type < X1f4_E4_CALL) {
		status = _libx1f4i0_lxcast_stat_lead(subtext, type);
	    }
	}
    }

    return status;
}
