/*
 * lxcast-a.e.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4.h>
#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <integral.v-d.h>
# include <lintegral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <lxcast-inter.h>
#include <lxcast-types.h>

#define lxcast(lxcast) \
    ((struct lxcast_type *) (lxcast))

static int make_type(void *, void *, int (*) (void *, const char *, unsigned),
		     unsigned);

static int
make_type(void *lxcast, void *data,
	  int (*push) (void *, const char *, unsigned), unsigned type)
{
    return x1f4_dump_type
	(data, push, type, lxcast(lxcast)->trap_e.eelookup_data);
}


int
_libx1f4i0_lxcast_stat_call(void *lxcast, int type)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxcast(lxcast)->link_e.data;

	line = lxcast(lxcast)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxcast(lxcast)->link_e.push;
	if (push) {
	    status = push(data, "non function pointer type (", 27);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dintegral(data, push, type);
		if (status) {
		    break;
		} else {
		    status = push(data, ")", 1);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxcast(lxcast)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_free(void *lxcast)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxcast(lxcast)->link_e.data;

	line = lxcast(lxcast)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxcast(lxcast)->link_e.push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = lxcast(lxcast)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxcast_stat_lead(void *lxcast, unsigned type)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxcast(lxcast)->link_e.data;

	line = lxcast(lxcast)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxcast(lxcast)->link_e.push;
	if (push) {
	    status = push
		(data, "will not box non referable, non intrinsic object of"
		 " type ", 57);
	    if (status) {
		break;
	    } else {
		status = make_type(lxcast, data, push, type);
		if (status) {
		    break;
		}
	    }
	}

	post = lxcast(lxcast)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_link(void *lxcast)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxcast(lxcast)->link_e.data;

	line = lxcast(lxcast)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxcast(lxcast)->link_e.push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = lxcast(lxcast)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxcast_stat_null(void *lxcast, const char *name, unsigned size)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxcast(lxcast)->link_e.data;

	line = lxcast(lxcast)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxcast(lxcast)->link_e.push;
	if (push) {
	    status = push(data, "function `", 10);
	    if (status) {
		break;
	    } else {
		status = push(data, name, size);
		if (status) {
		    break;
		} else {
		    status = push(data, "' admits no parameters", 22);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxcast(lxcast)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_slip(void *lxcast, const char *name, unsigned size,
			    unsigned mask, long mode)
{
    if (mask) {
	_libx1f4i0_lxcast_stat_time(lxcast, name, size, mask, mode);
    } else {
	_libx1f4i0_lxcast_stat_null(lxcast, name, size);
    }

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_time(void *lxcast, const char *name, unsigned size,
			    unsigned mask, long mode)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxcast(lxcast)->link_e.data;

	line = lxcast(lxcast)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxcast(lxcast)->link_e.push;
	if (push) {
	    status = push(data, "out of valid range (-", 21);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dcardinal(data, push, mask);
		if (status) {
		    break;
		} else {
		    status = push(data, " .. ", 4);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_dcardinal(data, push, mask - 1);
			if (status) {
			    break;
			} else {
			    status = push(data, ") parameter index (", 19);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_dlintegral
				    (data, push, mode);
				if (status) {
				    break;
				} else {
				    status = push
					(data, ") for function `", 16);
				    if (status) {
					break;
				    } else {
					status = push(data, name, size);
					if (status) {
					    break;
					} else {
					    status = push(data, "'", 1);
					    if (status) {
						break;
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = lxcast(lxcast)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_type(void *lxcast, int found, int expected)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxcast(lxcast)->link_e.data;

	line = lxcast(lxcast)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxcast(lxcast)->link_e.push;
	if (push) {
	    status = push
		(data, "mismatched type in conversion from `object' (", 45);
	    if (status) {
		break;
	    } else {
		status = make_type(lxcast, data, push, found);
		if (status) {
		    break;
		} else {
		    status = push(data, " found, ", 8);
		    if (status) {
			break;
		    } else {
			status = make_type(lxcast, data, push, expected);
			if (status) {
			    break;
			} else {
			    status = push(data, " expected)", 10);
			    if (status) {
				break;
			    }
			}
		    }
		}
	    }
	}

	post = lxcast(lxcast)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
