/*
 * lxcast-a.1.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxcast-defs.h>
#include <lxcast-types.h>

static int fini_list(struct lxcast_type *);
static int free_links(struct lxcast_type *, void *, int (*) (void *, void *));
static int free_fringe(struct fringe_type *, void *, int (*) (void *, void *));

static int
fini_list(struct lxcast_type *lxcast_data)
{
    int excess, (*free) (void *, void *), status;
    void *data;

    data = lxcast_data->link_w.data;
    free = lxcast_data->link_w.free;

    status = free_links(lxcast_data, data, free);

    excess = free(data, lxcast_data->link_f.data);
    if (excess) {
	status = FREE_ERROR;
    }

    excess = free(data, lxcast_data);
    if (excess) {
	status = FREE_ERROR;
    }

    return status;
}


static int
free_links(struct lxcast_type *lxcast_data, void *data,
	   int (*free) (void *, void *))
{
    int excess, status = 0;
    void *fringe;

    fringe = lxcast_data->link_k.driver_fringe;
    if (fringe) {
	excess = free_fringe(fringe, data, free);
	if (excess) {
	    status = FREE_ERROR;
	}
    }
    fringe = lxcast_data->link_k.object_fringe;
    if (fringe) {
	excess = free_fringe(fringe, data, free);
	if (excess) {
	    status = FREE_ERROR;
	}
    }

    return status;
}


static int
free_fringe(struct fringe_type *fringe_data, void *data,
	    int (*free) (void *, void *))
{
    int excess, status = 0;

    do {
	struct fringe_type *fringe_link;

	fringe_link = fringe_data->fringe_data;
	excess = free(data, fringe_data);
	if (excess) {
	    status = FREE_ERROR;
	}

	fringe_data = fringe_link;
    } while (fringe_data);

    return status;
}


int
x1f4_fini_lxcast(void **lxcast)
{
    return fini_list(*lxcast);
}
