/*
 * lxcast-a.0.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO/IMPROVE
 *
 * use better data structures for the driver_fringe/object_fringe arrays
 */

#include <stddef.h>
#include <string.h>

#include <e4-m.0.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcall.h>
#include <lxcast-defs.h>
#include <lxcast-inter.h>
#include <lxcast-types.h>
#include <retain.h>

#define I_BILL(b)			(*((X1f4_E4_C_BILL *) (b)))
#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))
#define I_REAL(r)			(*((X1f4_E4_C_REAL *) (r)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(u)			(*((X1f4_E4_C_USER *) (u)))

#define l_BILL(e, output) \
    {									      \
	X1f4_E4_C_BILL *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_REAL(e, output) \
    {									      \
	X1f4_E4_C_REAL *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define screen(screen) \
    ((struct screen_type *) (screen))

#define shut_size() \
    (sizeof(shut_high) / sizeof(struct x1f4_operator_type *))

extern const struct x1f4_eelookup_type _x1f4_type_lookup;

static int c19xx_f_f(void *, void **);
static int d19xx_b__(void *, void *, void **);
static int d19xx_m__(void *, void *, void **);
static int d19xx_r__(void *, void *, void **);
static int d19xx_t__(void *, void *, void **);
static int init_cast(struct lxcast_type *, unsigned,
		     const struct screen_type *);
static int line_cast(struct lxcast_type *, unsigned,
		     const struct screen_type *);
static int line_data(struct lxcast_type *, unsigned,
		     const struct screen_type *, void *, void *, void **,
		     void **);
static int line_lock(struct lxcast_type *, void *);
static int line_sail(struct lxcast_type *, const struct screen_type *,
		     struct lxtext_type *, const struct x1f4_nodetype_type *);
static int line_side(struct lxcast_type *, void *, void **);
static int line_text(struct lxcast_type *, unsigned,
		     const struct screen_type *, void *, void **, void **);
static int link_cast(struct lxcast_type *, unsigned,
		     const struct screen_type *);
static int o19xb_o__(void *, void *, void **);
static int o19xm_o__(void *, void *, void **);
static int o19xr_o__(void *, void *, void **);
static int o19xt_o__(void *, void *, void **);
static int pick_miss(unsigned *, unsigned *, unsigned *,
		     const struct screen_type *);

static void line__mix(v_case_args_____0);
static void line_cmap(u_case_args_____0);
static void line_ffix(u_case_args_____0);
static void line_fmap(u_case_args_____0);
static void line_fway(u_case_args_____0);
static void line_hfix(u_case_args_____0);
static void line_ifix(u_case_args_____0);
static void line_ofix(u_case_args_____0);
static void line_pmap(u_case_args_____0);
static void line_pway(u_case_args_____0);
static void line_rfix(u_case_args_____0);
static void line_tfix(u_case_args_____0);

static const int c_____b__[] = {
/* *INDENT-OFF* */
    X1f4_E4_BILL
/* *INDENT-ON* */
}, c_____m__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____f_f[] = {
/* *INDENT-OFF* */
    X1f4_E4_CALL,
    X1f4_E4_CALL
/* *INDENT-ON* */
}, c_____r__[] = {
/* *INDENT-OFF* */
    X1f4_E4_REAL
/* *INDENT-ON* */
}, c_____t__[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT
/* *INDENT-ON* */
};
static const struct line_type slip_line[] = {
/* *INDENT-OFF* */
#define __count_count			1
    {	{	"__count",
		_libx1f4i0_lxcast_c_pending,	X1f4_E4_MODE,
		NULL,				__count_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_cmap,							},
#define __count_reach			(0 + __count_count)
#define __fid_count			1
    {	{	"__fid",
		_libx1f4i0_lxcast_f_pending,	X1f4_E4_MODE,
		NULL,				__fid_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_fmap,							},
#define __fid_reach			(__count_reach + __fid_count)
#define __ftype_count			1
    {	{	"__ftype",
		_libx1f4i0_lxcast_f_derived,	X1f4_E4_TEXT,
		NULL,				__ftype_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_fway,							},
#define __ftype_reach			(__fid_reach + __ftype_count)
#define __function_count		1
    {	{	"__function",
		_libx1f4i0_lxcast_f_logique,	X1f4_E4_TEXT,
		NULL,				__function_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						10		},
	line_ffix,							},
#define __function_reach		(__ftype_reach + __function_count)
#define __hold_count			3
    {	{	"__hold",
		_libx1f4i0_lxcast_h_logique,	0,
		NULL,				__hold_count,
		0,				6		},
	line_hfix,							},
#define __hold_reach			(__function_reach + __hold_count)
#define __id_count			1
    {	{	"__id",
		_libx1f4i0_lxcast_i_logique,	X1f4_E4_MODE,
		NULL,				__id_count,
		0,				4		},
	line_ifix,							},
#define __id_reach			(__hold_reach + __id_count)
#define __object_count			1
    {	{	"__object",
		_libx1f4i0_lxcast_o_logique,	0,
		NULL,				__object_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_ofix,							},
#define __object_reach			(__id_reach + __object_count)
#define __pid_count			2
    {	{	"__pid",
		_libx1f4i0_lxcast_p_pending,	X1f4_E4_MODE,
		NULL,				__pid_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_pmap,							},
#define __pid_reach			(__object_reach + __pid_count)
#define __ptype_count			2
    {	{	"__ptype",
		_libx1f4i0_lxcast_p_derived,	X1f4_E4_TEXT,
		NULL,				__ptype_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_pway,							},
#define __ptype_reach			(__pid_reach + __ptype_count)
#define __referable_count			1
    {	{	"__referable",
		_libx1f4i0_lxcast_r_logique,	X1f4_E4_MODE,
		NULL,				__referable_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						11		},
	line_rfix,							},
#define __referable_reach		(__ptype_reach + __referable_count)
#define __type_count			1
    {	{	"__type",
		_libx1f4i0_lxcast_t_logique,	X1f4_E4_TEXT,
		NULL,				__type_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_tfix,							}
#define __type_reach			(__referable_reach + __type_count)
/* *INDENT-ON* */
#define slip_line_count			__type_reach
};
static const struct link_type fast_line[] = {
/* *INDENT-OFF* */
#define ___class			2
#define ___count			1
    {	{	"__",
		NULL,				0,
		NULL,				___count,
		X1f4_E4_TEXT_LINK,		___class	},
	line__mix,							},
#define ___reach			(0 + ___count)
#define ___trans			(0 + ___class)
/* *INDENT-ON* */
#define fast_line_class			___trans
#define fast_line_count			___reach
};
static const struct x1f4_function_type lock_i_o[] = {
/* *INDENT-OFF* */
    {	"(cardinal) ",		d19xx_b__,
	X1f4_E4_BILL,		NULL,
	1,			X1f4_E4_TEXT_LINK,
	11,							},
    {	"(integer) ",		d19xx_m__,
	X1f4_E4_MODE,		NULL,
	1,			X1f4_E4_TEXT_LINK,
	10,							},
    {	"(real) ",		d19xx_r__,
	X1f4_E4_REAL,		NULL,
	1,			X1f4_E4_TEXT_LINK,
	7,							},
    {	"(text) ",		d19xx_t__,
	X1f4_E4_TEXT,		NULL,
	1,			X1f4_E4_TEXT_LINK,
	7,							}
/* *INDENT-ON* */
}, lock_o_i[] = {
/* *INDENT-OFF* */
    {	"(object) ",		o19xb_o__,
	0,			c_____b__,
	1,			X1f4_E4_TEXT_LINK,
	7,							},
    {	"(object) ",		o19xm_o__,
	0,			c_____m__,
	1,			X1f4_E4_TEXT_LINK,
	7,							},
    {	"(object) ",		o19xr_o__,
	0,			c_____r__,
	1,			X1f4_E4_TEXT_LINK,
	7,							},
    {	"(object) ",		o19xt_o__,
	0,			c_____t__,
	1,			X1f4_E4_TEXT_LINK,
	7,							}
/* *INDENT-ON* */
};
static const struct x1f4_operator_type e19xx_f_f[] = {
/* *INDENT-OFF* */
    {	"=",			c19xx_f_f,	0400,
	X1f4_E4_CALL,		c_____f_f,
	X1f4_E4_BACK_LINK | X1f4_E4_CALL_XSET,
				1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, *const shut_high[] = {
/* *INDENT-OFF* */
    e19xx_f_f
/* *INDENT-ON* */
};

static int
c19xx_f_f(void *output, void **input)
{
    X1f4_E4_C_USER user;

    user = I_USER(input[1]);

    l_USER(user, output);
    l_USER(user, input[0]);

    return 0;
}


static int
d19xx_b__(void *context, void *output, void **input)
{
    int status = 0;
    struct dxcast_type *object_data;

    object_data = I_USER(input[0]);

    switch (object_data->type) {
    case X1f4_E4_BILL:
	l_BILL(I_BILL(&object_data->data), output);
	break;
    case X1f4_E4_MODE:
	l_BILL(I_MODE(&object_data->data), output);
	break;
    case X1f4_E4_REAL:
	l_BILL(I_REAL(&object_data->data), output);
	break;
    default:
	status = _libx1f4i0_lxcast_stat_type
	    (context, object_data->type, X1f4_E4_BILL);
    }

    return status;
}


static int
d19xx_m__(void *context, void *output, void **input)
{
    int status = 0;
    struct dxcast_type *object_data;

    object_data = I_USER(input[0]);

    switch (object_data->type) {
    case X1f4_E4_BILL:
	l_MODE(I_BILL(&object_data->data), output);
	break;
    case X1f4_E4_MODE:
	l_MODE(I_MODE(&object_data->data), output);
	break;
    case X1f4_E4_REAL:
	l_MODE(I_REAL(&object_data->data), output);
	break;
    default:
	status = _libx1f4i0_lxcast_stat_type
	    (context, object_data->type, X1f4_E4_MODE);
    }

    return status;
}


static int
d19xx_r__(void *context, void *output, void **input)
{
    int status = 0;
    struct dxcast_type *object_data;

    object_data = I_USER(input[0]);

    switch (object_data->type) {
    case X1f4_E4_BILL:
	l_REAL(I_BILL(&object_data->data), output);
	break;
    case X1f4_E4_MODE:
	l_REAL(I_MODE(&object_data->data), output);
	break;
    case X1f4_E4_REAL:
	l_REAL(I_REAL(&object_data->data), output);
	break;
    default:
	status = _libx1f4i0_lxcast_stat_type
	    (context, object_data->type, X1f4_E4_REAL);
    }

    return status;
}


static int
d19xx_t__(void *context, void *output, void **input)
{
    int status;
    struct dxcast_type *object_data;

    object_data = I_USER(input[0]);

    if (object_data->type ^ X1f4_E4_TEXT) {
	status = _libx1f4i0_lxcast_stat_type
	    (context, object_data->type, X1f4_E4_TEXT);
    } else {
	status = 0;

	l_TEXT(I_TEXT(&object_data->data), output);
    }

    return status;
}


static int
init_cast(struct lxcast_type *lxcast_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & CODELINK_LINK) {
	lxcast_data->link_w.data = screen_data->link_w.data;
	lxcast_data->link_w.free = screen_data->link_w.free;
	lxcast_data->link_w.link = screen_data->link_w.link;
	lxcast_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxcast_data->link_w.data = NULL;
	lxcast_data->link_w.free = _x1f4_e4_free_data;
	lxcast_data->link_w.link = _x1f4_e4_link_data;
	lxcast_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & EELOOKUP_LINK) {
	lxcast_data->trap_e.eelookup_data = screen_data->trap_e.eelookup_data;
    } else {
	lxcast_data->trap_e.eelookup_data = &_x1f4_type_lookup;
    }

    if (bits & RESOURCE_LINK) {
	lxcast_data->link_m.data = screen_data->link_m.data;
	lxcast_data->link_m.free = screen_data->link_m.free;
	lxcast_data->link_m.link = screen_data->link_m.link;
	lxcast_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxcast_data->link_m.data = NULL;
	lxcast_data->link_m.free = _x1f4_e4_free_data;
	lxcast_data->link_m.link = _x1f4_e4_link_data;
	lxcast_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxcast_data->link_e.data = screen_data->link_e.data;
	lxcast_data->link_e.line = screen_data->link_e.line;
	lxcast_data->link_e.post = screen_data->link_e.post;
	lxcast_data->link_e.push = screen_data->link_e.push;
    } else {
	lxcast_data->link_e.data = NULL;
	lxcast_data->link_e.line = NULL;
	lxcast_data->link_e.post = NULL;
	lxcast_data->link_e.push = NULL;
    }

    {
	lxcast_data->link_k.driver_fringe = NULL;
	lxcast_data->link_k.object_fringe = NULL;
    }

    if (bits & TRANSFER_LINK) {
	lxcast_data->link_o.fine = screen_data->link_o.fine;
    } else {
	lxcast_data->link_o.fine = NULL;
    }

    if (1) {
	lxcast_data->link_v.data = screen_data->link_v.data;
	lxcast_data->link_v.free = screen_data->link_v.free;
	lxcast_data->link_v.link = screen_data->link_v.link;
	lxcast_data->link_v.mode = screen_data->link_v.mode;
	lxcast_data->link_v.pick = screen_data->link_v.pick;
	lxcast_data->link_v.slip = screen_data->link_v.slip;
    }

    {
	lxcast_data->link_i.type = screen_data->link_i.type;
    }

    status = link_cast(lxcast_data, bits, screen_data);

    return status;
}


static int
line_cast(struct lxcast_type *lxcast_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    lxcast_data->link_t.datatype[0].context = lxcast_data;

    lxcast_data->link_t.datatype[0].flat = NULL;
#if __RETAIN_OBJECT_DATA__
    lxcast_data->link_t.datatype[0].lead = NULL;
#else
    lxcast_data->link_t.datatype[0].lead = _libx1f4i0_lxcast_lead_cast;
#endif				/* __RETAIN_OBJECT_DATA__ */
    lxcast_data->link_t.datatype[0].line = NULL;
    lxcast_data->link_t.datatype[0].link = NULL;
    lxcast_data->link_t.datatype[0].name = "object";
    lxcast_data->link_t.datatype[0].shut = NULL;
#if __RETAIN_OBJECT_DATA__
    lxcast_data->link_t.datatype[0].slip = NULL;
#else
    lxcast_data->link_t.datatype[0].slip = _libx1f4i0_lxcast_slip_cast;
#endif				/* __RETAIN_OBJECT_DATA__ */
    lxcast_data->link_t.datatype[0].size = 6;
    lxcast_data->link_t.datatype[0].type = screen_data->link_i.type;

    lxcast_data->link_t.datatype[1].context = NULL;

    lxcast_data->link_t.datatype[1].flat = NULL;
    lxcast_data->link_t.datatype[1].lead = NULL;
    lxcast_data->link_t.datatype[1].line = NULL;
    lxcast_data->link_t.datatype[1].link = NULL;
    lxcast_data->link_t.datatype[1].name = NULL;
    lxcast_data->link_t.datatype[1].shut = NULL;
    lxcast_data->link_t.datatype[1].slip = NULL;
    lxcast_data->link_t.datatype[1].size = 0;
    lxcast_data->link_t.datatype[1].type = 0;

    return 0;
}


static int
line_data(struct lxcast_type *lxcast_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void *text,
	  void **args, void **dana)
{
    struct lxtext_type *lxtext_data;
    const struct x1f4_nodetype_type *nodetype_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned i;

    nodetype_data = screen_data->link_t.data;

    linetext_data = data;
    lxtext_data = text;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	line_sail(lxcast_data, screen_data, lxtext_data, nodetype_data);
	if (1) {
	   _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, nodetype_data,
		 args, dana, sizeof(fast_line) / sizeof(struct link_type),
		 fast_line);
	}

	lxtext_data++;

	nodetype_data++;
    }

    return 0;
}


static int
line_lock(struct lxcast_type *lxcast_data, void *linetext)
{
    const struct x1f4_function_type *function_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned i;

    linetext_data = linetext;

    function_data = lock_i_o;

    for (i = 4; i; i--) {
	linetext_data->context = lxcast_data;
	linetext_data->function = *function_data;
	linetext_data->function.args = &lxcast_data->link_i.type;
	linetext_data++;
	function_data++;
    }

    function_data = lock_o_i;

    for (i = 4; i; i--) {
	linetext_data->context = lxcast_data;
	linetext_data->function = *function_data;
	linetext_data->function.type = lxcast_data->link_i.type;
	linetext_data++;
	function_data++;
    }

    return 0;
}


static int
line_sail(struct lxcast_type *lxcast_data,
	  const struct screen_type *screen_data,
	  struct lxtext_type *lxtext_data,
	  const struct x1f4_nodetype_type *nodetype_data)
{
    lxtext_data->nodetype = *nodetype_data;
    lxtext_data->text = lxcast_data;

    if (lxtext_data->nodetype.code == X1f4_E4_TEXT) {
	lxtext_data->nodetype.context = lxcast_data;
	lxtext_data->nodetype.lead = _libx1f4i0_lxcast_lead_text;
	lxtext_data->nodetype.slip = _libx1f4i0_lxcast_slip_text;
    }

    return 0;
}


static int
line_side(struct lxcast_type *lxcast_data, void *data, void **slip)
{
    struct x1f4_operator_type **operator, *operator_data;
    const struct x1f4_operator_type *const *shut;
    unsigned i;

    operator_data = data;

    operator = (void *) (operator_data + shut_size());

    *slip = operator;

    shut = shut_high;

    i = shut_size();
    for (; i; i--) {
	*operator++ = operator_data;
	*operator_data++ = **shut++;
    }

    *operator = NULL;

    return 0;
}


static int
line_text(struct lxcast_type *lxcast_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args,
	  void **dana)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxcast_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
link_cast(struct lxcast_type *lxcast_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_class, args_count, line_class, line_count, main_class,
	main_count, miss;
    void *data;

    args_count = 0;
    line_count = 1;
    main_count = 0;

    pick_miss(&args_class, &line_class, &main_class, screen_data);

    miss = screen_data->link_t.miss;

    {
	args_count += slip_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
    }

    status = lxcast_data->link_w.link
	(lxcast_data->link_w.data, &data,
	 (args_class + args_count) * sizeof(int)
	 + miss * sizeof(struct lxtext_type) + sizeof(struct lxmiss_type)
	 + (line_class + line_count + 8) * sizeof(struct x1f4_linetext_type)
	 + main_class + main_count
	 + (sizeof(struct x1f4_operator_type)
	    + sizeof(struct x1f4_operator_type *)) * shut_size()
	 + sizeof(struct x1f4_operator_type *));
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *lock, *slip, *tile, *text;

	tile = (struct x1f4_linetext_type *) data + line_class;
	lock = (struct x1f4_linetext_type *) tile + line_count;
	dana = (struct x1f4_linetext_type *) lock + 8;
	text = (struct lxmiss_type *) dana + 1;
	slip = (struct lxtext_type *) text + miss;
	args = (struct x1f4_operator_type *) slip + shut_size();
	args = (struct x1f4_operator_type **) args + (shut_size() + 1);
	dana = (int *) args + args_class + args_count;

	lxcast_data->link_f.data = data;
	lxcast_data->link_f.lock = lock;
	lxcast_data->link_f.text = text;

	((struct lxmiss_type *) text - 1)->data.miss = miss;

	line_data(lxcast_data, bits, screen_data, data, text, &args, &dana);
	line_text(lxcast_data, bits, screen_data, tile, &args, &dana);

	line_lock(lxcast_data, lock);

	line_side(lxcast_data, slip, &slip);

	lxcast_data->link_f.side = slip;

	line_cast(lxcast_data, bits, screen_data);
    }

    return status;
}


static int
o19xb_o__(void *context, void *output, void **input)
{
    int status;
    struct lxcast_type *lxcast_data;
    void *data;

    lxcast_data = context;

    status = lxcast_data->link_v.link
	(lxcast_data->link_v.data, &data, sizeof(struct dxcast_type));
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	struct dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = X1f4_E4_BILL;

	l_BILL(I_BILL(input[0]), &object_data->data);
    }

    return status;
}


static int
o19xm_o__(void *context, void *output, void **input)
{
    int status;
    struct lxcast_type *lxcast_data;
    void *data;

    lxcast_data = context;

    status = lxcast_data->link_v.link
	(lxcast_data->link_v.data, &data, sizeof(struct dxcast_type));
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	struct dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = X1f4_E4_MODE;

	l_MODE(I_MODE(input[0]), &object_data->data);
    }

    return status;
}


static int
o19xr_o__(void *context, void *output, void **input)
{
    int status;
    struct lxcast_type *lxcast_data;
    void *data;

    lxcast_data = context;

    status = lxcast_data->link_v.link
	(lxcast_data->link_v.data, &data, sizeof(struct dxcast_type));
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	struct dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = X1f4_E4_REAL;

	l_REAL(I_REAL(input[0]), &object_data->data);
    }

    return status;
}


static int
o19xt_o__(void *context, void *output, void **input)
{
    int status;
    struct lxcast_type *lxcast_data;
    void *data;

    lxcast_data = context;

    status = lxcast_data->link_v.link
	(lxcast_data->link_v.data, &data, sizeof(struct dxcast_type));
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	struct dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = X1f4_E4_TEXT;

	l_TEXT(I_TEXT(input[0]), &object_data->data);
    }

    return status;
}


static int
pick_miss(unsigned *args, unsigned *line, unsigned *pick,
	  const struct screen_type *screen_data)
{
    const struct x1f4_nodetype_type *nodetype_data;
    unsigned args_count = 0, line_count = 0, i, main_count = 0;

    nodetype_data = screen_data->link_t.data;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	unsigned deck;

	deck = nodetype_data->size + 1;

	args_count += fast_line_count;
	line_count += sizeof(fast_line) / sizeof(struct link_type);
	main_count += deck * sizeof(fast_line) / sizeof(struct link_type)
	    + fast_line_class;

	nodetype_data++;
    }

    *args = args_count;
    *line = line_count;
    *pick = main_count;

    return 0;
}


static void
line__mix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;

    *args = line;

    type = nodetype_data->code;

    if (0) {
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxcast___class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxcast___class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxcast___class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxcast___class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxcast___class_b;
			} else {
			}
		    }
		}
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_cmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;

    *args = line;
}


static void
line_ffix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;

    *args = line;
}


static void
line_fmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;

    *args = line;
}


static void
line_fway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;

    *args = line;
}


static void
line_hfix(u_case_args_____1)
{
    int *line, type;

    line = *args;

    type = screen(screen)->link_i.type;

    linetext_data->function.args = line;

    linetext_data->function.type = type;

    *line++ = X1f4_E4_MODE;
    *line++ = type;
    *line++ = type;

    *args = line;
}


static void
line_ifix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;

    *args = line;
}


static void
line_ofix(u_case_args_____1)
{
    int *line, type;

    line = *args;

    type = screen(screen)->link_i.type;

    linetext_data->function.args = line;

    linetext_data->function.type = type;

    *line++ = type;

    *args = line;
}


static void
line_pmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_pway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_rfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;

    *args = line;
}


static void
line_tfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_i.type;

    *args = line;
}


int
x1f4_init_lxcast(void **lxcast, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *cast, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &cast, sizeof(struct lxcast_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_cast(cast, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, cast);
	    } else {
		_x1f4_e4_free_data(text, cast);
	    }
	} else {
	    *lxcast = cast;
	}
    }

    return status;
}
