/*
 * lxcall-types.h
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxcall_types_H__
#define __LIBx1f4_lxcall_types_H__

#include <e4.h>
#include <nt.h>

#define u_case_args_____0 \
    const void *, struct x1f4_linetext_type *, void **
#define u_case_args_____1 \
    const void *screen, struct x1f4_linetext_type *linetext_data, void **args
#define u_case_args_____2 \
    screen, linetext_data, args

#define v_case_args_____0 \
    const void *, const struct x1f4_nodetype_type *,			      \
    struct x1f4_linetext_type *, void **
#define v_case_args_____1 \
    const void *screen, const struct x1f4_nodetype_type *nodetype_data,	      \
    struct x1f4_linetext_type *linetext_data, void **args
#define v_case_args_____2 \
    screen, nodetype_data, linetext_data, args

typedef struct line_type {
    struct x1f4_function_type function;
    void (*line) (u_case_args_____0);
} line_type;

typedef struct link_type {
    struct x1f4_function_type function;
    void (*line) (v_case_args_____0);
} link_type;

typedef struct qssc_type {
    struct x1f4_variable_type variable;
    const void *data;
} qssc_type;

typedef struct tide_type {
    struct x1f4_2ndscope_type tidespan;
    struct x1f4_operator_type operator;
} tide_type;

#endif				/* __LIBx1f4_lxcall_types_H__ */
