/*
 * lxcall-e.s.c
 * Copyright (C) 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <e4fine.h>
#include <lxcall-types.h>

int
_libx1f4i0_lxcall_miss_line(void *context, unsigned bits, void *fine,
			    struct qssc_type *qssc_data,
			    struct x1f4_linetext_type *linetext_data,
			    unsigned count)
{
    int status = 0;

    while (count) {
	qssc_data->data = linetext_data;

	qssc_data->variable.flags = X1f4_E4_READ_ONLY;
	qssc_data->variable.length = linetext_data->function.length;
	qssc_data->variable.name = linetext_data->function.name;

	status = x1f4_type_e4fine
	    (fine, &qssc_data->variable.type, linetext_data);
	if (status) {
	    break;
	}

	linetext_data++;

	qssc_data++;

	count--;
    }

    return status;
}
