/*
 * lxcall-e.n.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <e4.h>
#include <lxcall-types.h>
#include <nt.h>

int
_libx1f4i0_lxcall_push_line(void *context, unsigned bits, void *screen,
			    struct x1f4_linetext_type **linetext,
			    const struct x1f4_nodetype_type *nodetype_data,
			    void **args, void **dana, unsigned count,
			    const struct link_type *link_data)
{
    const char *name;
    char *text;
    struct x1f4_linetext_type *linetext_data;
    unsigned size;

    linetext_data = *linetext;

    size = nodetype_data->size;

    name = nodetype_data->name;

    text = *dana;

    while (count) {
	unsigned length;

	linetext_data->context = context;

	length = link_data->function.length;

	linetext_data->function = link_data->function;

	link_data->line(screen, nodetype_data, linetext_data, args);

	linetext_data->function.length = length + size;

	linetext_data->function.name = text;

	memcpy(text, link_data->function.name, length);
	text += length;
	memcpy(text, name, size);
	text += size;
	text[0] = 0;
	text++;

	linetext_data++;

	link_data++;

	count--;
    }

    *dana = text;

    *linetext = linetext_data;

    return 0;
}

