/*
 * lxbail-types.h
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxbail_types_H__
#define __LIBx1f4_lxbail_types_H__

typedef struct lxbail_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	unsigned bail, call, tear;
	void *pset, *qset;
    } link_i;
    struct {
	int (*free) (void *, void *);
	void *data;
    } link_m;
} lxbail_type;

typedef struct screen_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
    struct {
	unsigned down, tear;
    } link_i;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} screen_type;

#endif				/* __LIBx1f4_lxcast_types_H__ */
