/*
 * lxbail-a.3.c
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <bqfset.h>
#include <ln.h>
#include <lxbail-types.h>
#include <lxlead.h>
#include <nl.h>

static int blue_moon(void *, void *);
static int pick_link(void *, void *, struct x1f4_nodelink_type *);

static int
blue_moon(void *none, void *nodelink)
{
    struct x1f4_nodeline_type *nodeline_data;

    nodeline_data = *(void **) nodelink;
    nodeline_data--;
    nodeline_data->call--;

    return 0;
}


static int
pick_link(void *pset, void *qset, struct x1f4_nodelink_type *nodelink_data)
{
    struct x1f4_nodeline_type *nodeline_data;

    x1f4_cast_bqpset(pset, nodelink_data);

    if (x1f4_post_bqpset(qset, nodelink_data)) {
    } else {
	nodeline_data = (void *) nodelink_data;
	nodeline_data--;
	nodeline_data->call++;
    }

    return 0;
}


int
x1f4_pass_lxbail(void *lxbail)
{
    int excess, status = 0;
    struct lxbail_type *lxbail_data;
    void *pset, *qset;

    lxbail_data = lxbail;

    pset = lxbail_data->link_i.pset;

    qset = lxbail_data->link_i.qset;

    while (x1f4_case_bqfset(pset)) {
	int linked;
	struct x1f4_nodelink_type *nodelink_fail, *nodelink_text = NULL;
	void *tile;

	x1f4_ever_bqfset(pset, &tile);

	nodelink_fail = *(void **) tile;

	linked = x1f4_case_lxlead(&nodelink_text, nodelink_fail);
	if (linked) {
	    if (nodelink_text) {
		struct x1f4_nodelink_type *excase_data;

		excase_data = nodelink_text;
		while (1) {
		    struct x1f4_nodelink_type *excase_slip;

		    pick_link(pset, qset, excase_data);

		    excase_slip = excase_data->slip;
		    excase_data->slip = NULL;
		    if (excase_slip) {
			pick_link(pset, qset, excase_slip);

			excase_data = excase_slip->slip;
			excase_slip->slip = NULL;
			if (excase_data) {
			} else {
			    break;
			}
		    } else {
			break;
		    }
		}
	    } else {
		pick_link(pset, qset, nodelink_fail);
	    }
	} else {
	    excess = x1f4_pass_lxlead(NULL, nodelink_text);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    x1f4_lime_bqfset(qset, NULL, blue_moon);

    excess = x1f4_high_bqfset(qset);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    return 0;
}
