/*
 * lxbail-a.2.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <bqfset.h>
#include <exerrors.h>
#include <lxbail-inter.h>
#include <lxbail-types.h>
#include <lxlead.h>
#include <nl.h>

int
x1f4_miss_lxbail(void *lxbail, struct x1f4_nodelink_type **nodelink,
		 struct x1f4_nodelink_type *nodelink_data)
{
    int linked, status;
    struct lxbail_type *lxbail_data;
    struct x1f4_nodelink_type *nodelink_text = NULL;
    unsigned call;

    lxbail_data = lxbail;

    call = lxbail_data->link_i.call;

    linked = x1f4_seek_lxlead
	(&nodelink_text, nodelink_data, lxbail_data->link_i.tear);
    if (linked) {
	if (linked < 0) {
	    status = x1f4_post_bqpset(lxbail_data->link_i.pset, nodelink_data);
	    if (status) {
		if (status == X1f4_BQFSET_EVER_MATCH) {
		    status = 0;
		} else {
		    status = _libx1f4i0_lxbail_stat_fset(lxbail_data, status);
		}
	    }

	    call--;
	    if (call) {
		lxbail_data->link_i.call = call;
	    } else {
		lxbail_data->link_i.call = lxbail_data->link_i.bail;
		if (status) {
		} else {
		    x1f4_pass_lxbail(lxbail_data);
		}
	    }
	} else {
	    status = 0;
	}
    } else {
	status = x1f4_pass_lxlead(nodelink, nodelink_text);
    }

    return status;
}
