/*
 * lstring.l.2.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#define __DUMB_SEEK__			0
#define __ZERO_SEEK__			2

#define __HERE_SEEK__			__ZERO_SEEK__

#define ____HERE_SEEK__			__HERE_SEEK__

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_UNSIGNED_LONG == 4
# define HEAD_ZERO			0x80808080ul
# define MISS_ZERO			0x01010101ul
#else
# define HEAD_ZERO			0x8080808080808080ul
# define MISS_ZERO			0x0101010101010101ul
#endif				/* SIZEOF_UNSIGNED_LONG == 4 */

int
_libx1f4i0_pick_lstring(void *data, unsigned size, void *call, unsigned mind,
			unsigned *fast)
{
    char *line;
    unsigned lock;
#if ____HERE_SEEK__ == __DUMB_SEEK__
#else
    unsigned slip;
#endif				/* ____HERE_SEEK__ == __DUMB_SEEK__ */

    line = data;

    if (mind) {
	if (size < mind) {
	    line += size;
	    lock = 0;
	    mind = 0;
	    size = 0;
	} else {
	    lock = *(char *) call;
	    mind--;
	    size -= mind;
	}
    } else {
	lock = 0;
	size = 0;
    }

#if ____HERE_SEEK__ == __DUMB_SEEK__
    while (size) {
	if (*line == lock) {
	    char *file, *tile;
	    unsigned i;

	    file = line;
	    tile = call;

	    i = mind;
	    for (; i; i--) {
		if (*++file ^ *++tile) {
		    break;
		}
	    }

	    if (i) {
	    } else {
		break;
	    }
	}

	line++;
	size--;
    }
#else
    slip =
	(SIZEOF_UNSIGNED_LONG
	 - ((integral_q) data & (SIZEOF_UNSIGNED_LONG - 1)))
	& (SIZEOF_UNSIGNED_LONG - 1);
    if (slip) {
	if (size < slip) {
	    slip = size;
	}

	size -= slip;

	while (slip) {
	    if (*line == lock) {
		char *file, *tile;
		unsigned i;

		file = line;
		tile = call;

		i = mind;
		for (; i; i--) {
		    if (*++file ^ *++tile) {
			break;
		    }
		}

		if (i) {
		} else {
		    mind = 0;
		    size = 0;
		    if (1) {
			break;
		    }
		}
	    }

	    line++;
	    slip--;
	}
    }
#endif				/* ____HERE_SEEK__ == __DUMB_SEEK__ */

#if ____HERE_SEEK__ == __ZERO_SEEK__
    if (size) {
	slip = size / SIZEOF_UNSIGNED_LONG;
	if (slip) {
	    unsigned long *deck, hole;

	    hole = lock & 00377;

	    hole |= hole << 010;
	    hole |= hole << 020;
# if SIZEOF_UNSIGNED_LONG == 8
	    hole |= hole << 040;
# endif				/* SIZEOF_UNSIGNED_LONG == 8 */

	    deck = (unsigned long *) line;

	    do {
		unsigned long this;

		this = *deck ^ hole;
		if (((this - MISS_ZERO) & ~this) & HEAD_ZERO) {
		    unsigned near = SIZEOF_UNSIGNED_LONG;

		    line = (char *) deck;

		    while (near) {
			if (*line == lock) {
			    char *file, *tile;
			    unsigned i;

			    file = line;
			    tile = call;

			    i = mind;
			    for (; i; i--) {
				if (*++file ^ *++tile) {
				    break;
				}
			    }

			    if (i) {
			    } else {
				break;
			    }
			}

			line++;
			near--;
		    }

		    if (near) {
			mind = 0;
			size = 0;
			if (1) {
			    break;
			}
		    }
		}

		slip--;
		if (slip) {
		    deck++;
		} else {
		    size = size & (SIZEOF_UNSIGNED_LONG - 1);

		    line = (char *) (deck + 1);

		    break;
		}
	    } while (1);
	}

	if (size) {
	    do {
		if (*line == lock) {
		    char *file, *tile;
		    unsigned i;

		    file = line;
		    tile = call;

		    i = mind;
		    for (; i; i--) {
			if (*++file ^ *++tile) {
			    break;
			}
		    }

		    if (i) {
		    } else {
			break;
		    }
		}

		line++;
		size--;
	    } while (size);
	}
    }
#endif				/* ____HERE_SEEK__ == __ZERO_SEEK__ */

    if (size) {
    } else {
	line += mind;
    }

    *fast = line - (char *) data;

    return 0;
}
