/*
 * lcardinal.p-fb.c
 * Copyright (C) 2002-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

static const char lower_cases[] = "0123456789abcdefghijklmnopqrstuvwxyz",
    upper_cases[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

void
x1f4_xprint_fblcardinal(char **output, int big, unsigned f, unsigned b,
			unsigned base, unsigned long c)
{
    char *o;
    const char *digits;

    digits = !big ? lower_cases : upper_cases;

    o = *output;

    if (!b) {
	if (!f) {
	    do {
		--o;
		*o = digits[c % base];
		c /= base;
	    } while (c);
	} else {
	    while (1) {
		--o;
		*o = digits[c % base];
		c /= base;
		if (f) {
		    f--;
		}
		if (!(c | f)) {
		    break;
		}
	    }
	}
    } else {
	unsigned l;

	l = b;

	if (!f) {
	    do {
		if (!l) {
		    --o;
		    *o = ',';
		    l = b;
		}
		--l;
		--o;
		*o = digits[c % base];
		c /= base;
	    } while (c);
	} else {
	    while (1) {
		if (!l) {
		    --o;
		    *o = ',';
		    l = b;
		}
		--l;
		--o;
		*o = digits[c % base];
		c /= base;
		if (f) {
		    f--;
		}
		if (!(c | f)) {
		    break;
		}
	    }
	}
    }

    *output = o;
}
