/*
 * ix.h
 * Copyright (C) 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_ix_H__
#define __LIBx1f4_ix_H__

#include <dt.h>
#include <e2line.h>
#include <e4.h>
#include <lxslip.h>
#include <nt.h>

typedef struct x1f4_indexset_type {
    struct {
	void *text;
    } function_set;
    struct {
	void *text;
    } variable_set;
    struct {
	struct x1f4_datatype_type *datatype_data;
    } datatype_set;
    struct {
	struct x1f4_nodetype_type *nodetype_data;
	unsigned miss;
    } nodetype_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int type;
    } casttype_set;
    struct {
	int (*deck) (void *, void **);
	struct x1f4_e2line_type e2line;
	void *less, *text;
    } autodeck_set;
    struct {
	struct x1f4_lxslip_type *lxslip_data;
	unsigned miss;
    } sliplong_set;
    struct {
	const struct x1f4_operator_type *const *operator1s, *const *operator2s;
    } operator_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } codelink_set;
    struct {
	struct x1f4_eelookup_type eelookup;
    } eelookup_set;
} x1f4_indexset_type;

#endif				/* __LIBx1f4_ix_H__ */
