/*
 * ix.1.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <ix-defs.h>
#include <ix-types.h>
#include <nt.h>

int
x1f4_look_indexset(const void *context, int type, const char **name,
		   unsigned *size)
{
    int delete = 1;
    const struct indexset_type *indexset_data;
    const struct x1f4_nodetype_type *nodetype_data;
    unsigned count;

    indexset_data = context;

    nodetype_data = indexset_data->nodetype_set.nodetype_data;
    nodetype_data += LIST_TYPES;

    count = indexset_data->nodetype_set.miss - LIST_TYPES;
    for (; count; count--) {
	if (nodetype_data->code == type) {
	    *name = nodetype_data->name;
	    *size = nodetype_data->size;

	    delete = 0;

	    break;
	} else {
	    nodetype_data++;
	}
    }
    if (delete) {
	if (type == X1f4_E4_VOID) {
	    *name = "void";
	    *size = 4;

	    delete = 0;
	} else {
	    if (type == indexset_data->casttype_set.type) {
		*name = "object";
		*size = 6;

		delete = 0;
	    } else {
	    }
	}
    }

    return delete;
}
