/*
 * float.v-pw.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <float.x.h>
# include <space.v.h>
#endif				/* !LIBx1f4i0 */

int
x1f4_vprint_pwfloat(void *data, int (*this) (void *, const char *, unsigned),
		    int alignment, unsigned width, unsigned Precision,
		    unsigned precision, double value)
{
    char buffer[312];
    int status;
    unsigned diff = 0, digits, length;

    length = x1f4_xprint_cfloat(buffer, precision, value, &digits);

    if (digits < Precision) {
	diff = Precision - digits;
	if (!digits) {
	    diff++;
	}
	if (width < length) {
	    width = 0;
	} else {
	    if (alignment) {
		alignment = 0;
		if (length + diff < width) {
		    diff = width - length;
		}
		width = 0;
	    } else {
		if (diff < width) {
		    width -= diff;
		} else {
		    width = 0;
		}
	    }
	}
    }
    if (!(length < width)) {
	status = this(data, buffer, length);
    } else {
	if (!alignment) {
	    status = x1f4_vprint_space(data, this, width - length);
	    if (!status) {
		status = this(data, buffer, length);
	    }
	} else {
	    status = this(data, buffer, length);
	    if (!status) {
		status = x1f4_vprint_space(data, this, width - length);
	    }
	}
    }
    if (!status) {
	if (diff) {
	    status = x1f4_vprint_space(data, this, diff);
	}
    }

    return status;
}
