/*
 * float.e.c
 * Copyright (C) 2002-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <math.h>
#include <stddef.h>
#include <string.h>

#define LOG_10_BY_LOG_2_TIMES_65536	217706

int
x1f4_eprint_cfloat(char *wide_buffer, unsigned precision, double value,
		   unsigned *c_digits, char **output)
{
    char *string = "";
    unsigned digits = 0, wide_length = 0;

    if (finite(value)) {
	int zero = 0;

	if (value) {
	    char buffer[309], *fractional_output, *integral_output;
	    int exponent;
	    unsigned bits[2], fractional_digits, integral_digits, length, sign;

	    if (1) {
		unsigned *slip;

		slip = (void *) &value;
#if WORDS_BIGENDIAN
		bits[0] = slip[0];
		bits[1] = slip[1];
#else
		bits[0] = slip[1];
		bits[1] = slip[0];
#endif				/* WORDS_BIGENDIAN */
	    }

	    sign = bits[0] & (1 << 31);
	    exponent = (int) ((bits[0] >> 20) & 0x7ff) - 1022;

	    integral_digits = 0 < exponent ? exponent : 0;
	    if (integral_digits) {
		unsigned left, mantissa_integral_digits, offset = 53, units;
		unsigned short kbit[64], *mantissa;

		mantissa_integral_digits =
		    integral_digits < 53 ? integral_digits : 53;
		mantissa = (unsigned short *) &kbit
		    + ((1024 - integral_digits) >> 4);
		units = 64 - (mantissa - (unsigned short *) &kbit);

		bits[0] &= ~0 >> 12;
		bits[0] |= 1 << 20;
		left = integral_digits;
		memset(kbit, '\0', 128);
		while (mantissa_integral_digits) {
		    unsigned transfer;

		    transfer = left & 15;
		    if (!transfer) {
			transfer = 16;
		    }
		    if (offset < transfer) {
			transfer = offset;
		    } else if (32 < offset && offset - transfer < 32) {
			transfer = offset - 32;
		    }
		    mantissa_integral_digits -= transfer;
		    offset -= transfer;
		    left -= transfer;
		    *mantissa |= ((bits[31 < offset ? 0 : 1] >> (offset & 31))
				  & ((1 << transfer) - 1)) << (left & 15);
		    if (!(left & 15)) {
			mantissa++;
		    }
		}

		integral_output = (char *) buffer + 309;
		mantissa = (unsigned short *) &kbit + 64 - units;
		while (units) {
		    unsigned decrement = 0, transfer = 0;

		    for (left = units; left; left--) {
			unsigned quotient;

			transfer |= mantissa[units - left];
			quotient = transfer / 10;
			if (quotient || left != units) {
			    mantissa[units - left] = quotient;
			} else {
			    decrement = 1;
			}
			transfer %= 10;
			if (left == 1) {
			    *--integral_output = 0x30 + transfer;
			} else {
			    transfer <<= 16;
			}
		    }

		    if (decrement) {
			units--;
			mantissa++;
		    }
		}
	    } else {
		integral_output = (char *) buffer + 309;
	    }

	    fractional_digits =
		integral_digits < 53 ? 53 - integral_digits : 0;
	    if (fractional_digits && precision) {
		unsigned left, mantissa_fractional_digits, offset = 53, slip,
		    track, trailing = 0, units;
		unsigned short thousand_eighty_eight_bit[68], *mantissa;

		mantissa_fractional_digits = fractional_digits;
		left = exponent < 0 ? -exponent : 0;
		mantissa =
		    (unsigned short *) thousand_eighty_eight_bit + (left >> 4);

		bits[0] &= ~0 >> 12;
		bits[0] |= 1 << 20;
		memset(thousand_eighty_eight_bit, '\0', 136);
		offset -= integral_digits;
		while (mantissa_fractional_digits) {
		    unsigned transfer;

		    transfer = ((left ^ 15) & 15) + 1;
		    if (!transfer) {
			transfer = 16;
		    }
		    if (offset < transfer) {
			transfer = offset;
		    } else {
			if (32 < offset && offset - transfer < 32) {
			    transfer = offset - 32;
			}
		    }
		    mantissa_fractional_digits -= transfer;
		    offset -= transfer;
		    left += transfer;
		    *mantissa |= ((bits[31 < offset ? 0 : 1] >> (offset & 31))
				  & ((1 << transfer) - 1))
			<< (((left ^ 15) + 1) & 15);
#if 0
                        & ((1 << transfer) - 1)) << ((16 - left % 16) % 16);
#endif				/* 0 */
		    if (left & 15) {
		    } else {
			mantissa++;
		    }
		}
		units = mantissa - thousand_eighty_eight_bit;

		track = left;
		slip = 0;

		fractional_output = buffer;
		mantissa = thousand_eighty_eight_bit;
		while (~units && precision
		       && fractional_output != integral_output) {
		    int b0 = 1, bf = 1;
		    unsigned decrement = 0, f = 0, transfer = 0;

		    precision--;

		    slip += LOG_10_BY_LOG_2_TIMES_65536;

		    for (left = units; ~left; left--) {
			unsigned m, s;

			m = mantissa[left];
			f |= m;
			transfer += m * 10;
			if (transfer & 65535 || left != units) {
			    mantissa[left] = transfer;
			} else {
			    decrement = 1;
			}
			transfer >>= 16;

			s = slip >> 16;
			if (s < track) {
			    s = track - s;
			    if (left << 4 < s) {
				unsigned z = 65535;

				m = mantissa[left];

				s -= left << 4;
				if (s < 16) {
				    z <<= 16 - s;
				    z &= 65535;
				    m &= z;
				} else {
				}

				if (m) {
				    b0 = 0;
				    if (m ^ z) {
					bf = 0;
				    }
				} else {
				    bf = 0;
				}
			    }
			}
		    }
		    if (f) {
		    } else {
			break;
		    }

		    if (bf) {
			trailing = 0;

			if (transfer ^ 9) {
			    *fractional_output++ = 0x31 + transfer;
			    if (1) {
				break;
			    }
			} else {
			    char *f_output;
			    unsigned d;

			    f_output = fractional_output;
			    d = f_output - (char *) buffer;
			    for (; d; d--) {
				f_output--;
				if (*f_output ^ 0x39) {
				    break;
				} else {
				}
			    }

			    if (d) {
				fractional_output = f_output;
				*fractional_output++ = *f_output + 1;
				if (1) {
				    break;
				}
			    } else {
				*fractional_output++ = 0x39;
			    }
			}
		    } else {
			*fractional_output++ = 0x30 + transfer;

			if (transfer) {
			    trailing = 0;
			} else {
			    trailing++;
			}

			if (b0) {
			    break;
			}
		    }

		    if (slip >> 16 < track) {
		    } else {
			break;
		    }

		    if (decrement) {
			units--;
		    }
		}

		if (precision && trailing) {
		    fractional_output -= trailing;
		}
	    } else {
		fractional_output = buffer;
	    }

	    integral_digits = 309 - (integral_output - (char *) buffer);
	    fractional_digits = fractional_output - (char *) buffer;

	    length = fractional_digits + integral_digits;
	    if (length) {
		string = wide_buffer;
		if (sign) {
		    length++;
		}
		if (fractional_digits) {
		    length++;
		}
		wide_length = length;
		if (sign) {
		    *string++ = 055;
		}
		if (integral_digits) {
		    memcpy(string, integral_output, integral_digits);
		    string += integral_digits;
		}
		if (fractional_digits) {
		    *string++ = 056;
		    memcpy(string, buffer, fractional_digits);
		}
		string[fractional_digits] = 0;
		string = wide_buffer;

		digits = fractional_digits;
	    } else {
		zero = 1;
	    }
	} else {
	    zero = 1;
	}
	if (!zero) {
	} else {
	    unsigned *b_value;

	    b_value = (void *) &value;
#if WORDS_BIGENDIAN
	    if (*b_value & (1 << 31)) {
#elif 0
	    }
#else
	    if (b_value[1] & (1 << 31)) {
#endif				/* WORDS_BIGENDIAN */
		string = "-0";
		wide_length = 2;
	    } else {
		string = "0";
		wide_length = 1;
	    }
	}
    } else {
	if (isnan(value)) {
	    string = "NaN";
	    wide_length = 3;
	} else {
	    if (value < 0) {
		string = "-inf";
		wide_length = 4;
	    } else {
		string = "inf";
		wide_length = 3;
	    }
	}
    }

    if (c_digits) {
	*c_digits = digits;
    }

    *output = string;

    return wide_length;
}
