/*
 * file.o.t.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <file-types.h>
#include <lxdata.h>
#include <trans.h>

#define file(file) \
    ((struct aofile_type *) (file))

extern const struct sffile_type _libx1f4_file_o_sdfile;

int
_libx1f4i0_land_ofile(void *file, void *data, void *text)
{
    struct adfile_type *adfile_data;

    adfile_data = (void *) &file(file)->sd;

    adfile_data->slip = 0;
    adfile_data->text = text;

    x1f4_node_lxdata(NULL, &adfile_data->data, data, NULL);

    file(file)->ever = 0;
    file(file)->size = 0;

    file(file)->sf = &_libx1f4_file_o_sdfile;

    return 0;
}
