/*
 * file.o.r.c
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <stddef.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-types.h>
#include <lxdata.h>

#define file(file) \
    ((struct adfile_type *) (file))

static int lose_file(void *);
static int push_file(void *, void *, unsigned);
static int zero_file(void *);

static off_t seek_file(void *, off_t, int);

const struct sffile_type _libx1f4_file_o_sdfile = {
/* *INDENT-OFF* */
    zero_file,
    lose_file,
    NULL,
    push_file,
    seek_file
/* *INDENT-ON* */
};

static int
lose_file(void *file)
{
    return x1f4_free_lxdata(file(file)->text, file(file)->data, NULL, NULL);
}


static int
push_file(void *file, void *flat, unsigned size)
{
    int status;
    unsigned slip;

    slip = file(file)->slip;

    status = x1f4_rule_lxdata
	(file(file)->text, file(file)->data, slip, size, flat);
    if (status) {
	errno = ENOMEM;
	status = -1;
    } else {
	status = size;
	file(file)->slip = slip + size;
    }

    return status;
}


static int
zero_file(void *file)
{
    return 0;
}


static off_t
seek_file(void *file, off_t offset, int whence)
{
    int status = 0;

    switch (whence) {
    case SEEK_CUR:
	offset += file(file)->slip;
	break;
    case SEEK_END:
	offset += ((struct x1f4_dxdata_type *) file(file)->data)->length;
	break;
    case SEEK_SET:
	break;
    default:
	status = -1;
    }

    if (status) {
	errno = EINVAL;
    } else {
	if (offset < 0) {
	    errno = EINVAL;
	    status = -1;
	} else {
	    file(file)->slip = offset;
	    status = offset;
	}
    }

    return status;
}
