/*
 * file.o.3.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct aofile_type *) (file))

int
_libx1f4i0_fast_ofile(void *file)
{
    int status;

    do {
	unsigned miss;

	miss = file(file)->size;

	if (miss) {
	    int (*push)(void *, void *, unsigned);
	    void *sd;

	    push = file(file)->sf->push;

	    sd = &file(file)->sd;

	    if (1) {
		void *slip;

		slip = data(file, file(file)->ever);

		while (1) {
		    status = push(sd, slip, miss);
		    if (status == -1) {
			if (errno == EINTR) {
			} else {
			    status = PUSH_CLASS;
			    if (1) {
				break;
			    }
			}
		    } else {
			if (status) {
			    miss = miss - status;
			    if (miss) {
				slip = (char *) slip + status;
			    } else {
				status = 0;

				break;
			    }
			} else {
			    status = ZERO_CLASS;
			    if (1) {
				break;
			    }
			}
		    }
		}

		if (status) {
		    break;
		}
	    }
	} else {
	    status = 0;
	}
    } while (0);

    return status;
}
