/*
 * file.o.2.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct aofile_type *) (file))

static int find_line(void *, unsigned, unsigned *);

static int
find_line(void *data, unsigned size, unsigned *fast)
{
    char *line;

    line = (char *) data + size;
    while (1) {
	--line;
	if (*line == 10) {
	    *fast = line - (char *) data + 1;

	    break;
	} else {
	    size--;
	    if (size) {
	    } else {
		*fast = 0;

		break;
	    }
	}
    }


    return 0;
}


int
_libx1f4i0_push_ofile(void *file, void *data, unsigned size)
{
    int status;

    do {
	unsigned line, miss;

	if (size) {
	    find_line(data, size, &line);
	} else {
	    line = 0;
	}

	miss = file(file)->size;

	if (line || EVER_MAX < miss + size) {
	    int (*push)(void *, void *, unsigned);
	    unsigned post;
	    void *sd;

	    post = size - line;

	    push = file(file)->sf->push;

	    sd = &file(file)->sd;

	    if (miss) {
		void *slip;

		slip = data(file, file(file)->ever);

		while (1) {
		    status = push(sd, slip, miss);
		    if (status == -1) {
			if (errno == EINTR) {
			} else {
			    status = PUSH_CLASS;
			    if (1) {
				break;
			    }
			}
		    } else {
			if (status) {
			    miss = miss - status;
			    if (miss) {
				slip = (char *) slip + status;
			    } else {
				status = 0;

				break;
			    }
			} else {
			    status = ZERO_CLASS;
			    if (1) {
				break;
			    }
			}
		    }
		}

		if (status) {
		    break;
		}
	    }

	    if (post < LINE_MAX) {
	    } else {
		line = size;
		post = 0;
	    }

	    if (line) {
		size = line;

		while (1) {
		    status = push(sd, data, size);
		    if (status == -1) {
			if (errno == EINTR) {
			} else {
			    status = PUSH_CLASS;
			    if (1) {
				break;
			    }
			}
		    } else {
			if (status) {
			    size = size - status;
			    if (size) {
				data = (char *) data + status;
			    } else {
				status = 0;

				break;
			    }
			} else {
			    status = ZERO_CLASS;
			    if (1) {
				break;
			    }
			}
		    }
		}

		if (status) {
		    break;
		}
	    }

	    status = 0;

	    file(file)->ever = 0;
	    file(file)->size = post;

	    if (post) {
		memcpy(file(file) + 1, (char *) data + line, post);
	    }
	} else {
	    unsigned ever;

	    ever = file(file)->ever;

	    if (EVER_MAX < ever + miss + size) {
		memmove(file(file) + 1, data(file, ever), miss);
		ever = 0;
	    }

	    status = 0;

	    file(file)->size = miss + size;

	    memcpy(data(file, ever + miss), data, size);
	}
    } while (0);

    return status;
}
