/*
 * file.i.k.c
 * Copyright (C) 2008-2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

int
_libx1f4i0_skip_ifile(void *file, unsigned skip, unsigned *size)
{
    int status;

    do {
	int (*pull)(void *, void *, unsigned);
	unsigned fast, miss;
	void *sd;

	miss = file(file)->size;
	if (miss) {
	    if (skip < miss) {
		file(file)->ever = file(file)->ever + skip;
		file(file)->size = miss - skip;

		status = 0;

		*size = skip;

		if (1) {
		    break;
		}
	    } else {
		if (skip ^ miss) {
		    fast = miss;

		    skip -= miss;
		} else {
		    file(file)->ever = 0;
		    file(file)->size = 0;

		    status = 0;

		    *size = skip;

		    if (1) {
			break;
		    }
		}
	    }
	} else {
	    if (skip) {
		fast = 0;
	    } else {
		status = 0;

		*size = 0;

		if (1) {
		    break;
		}
	    }
	}

	pull = file(file)->sf->pull;

	sd = &file(file)->sd;

	if (1) {
	    while (1) {
		status = pull(sd, file(file) + 1, EVER_MAX);
		if (status == -1) {
		    if (errno == EINTR) {
		    } else {
			status = READ_CLASS;
			if (1) {
			    break;
			}
		    }
		} else {
		    if (status) {
			if (status < skip) {
			    fast += status;
			    skip -= status;
			} else {
			    fast += skip;

			    file(file)->ever = skip;
			    file(file)->size = status - skip;

			    status = 0;

			    *size = fast;

			    if (1) {
				break;
			    }
			}
		    } else {
			file(file)->ever = 0;
			file(file)->size = 0;

			if (!fast) {
			    status = OVER_CLASS;
			    if (1) {
				break;
			    }
			} else {
			    status = 0;

			    *size = fast;

			    if (1) {
				break;
			    }
			}
		    }
		}
	    }
	}
    } while (0);

    return status;
}
