/*
 * file.i.h.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>
#include <trans.h>

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

int
_libx1f4i0_read_ifile(void *file, void **line, unsigned *size, unsigned call,
		      struct trans_type *trans_data)
{
    int status;

    do {
	int (*pull)(void *, void *, unsigned);
	unsigned fast, miss;
	void *data, *sd;

	status = trans_data->link(trans_data->data, &data, call + 1);
	if (status) {
	    status = LINK_CLASS;
	    if (1) {
		break;
	    }
	}

	miss = file(file)->size;
	if (miss) {
	    unsigned ever;

	    ever = file(file)->ever;

	    if (miss < call) {
		memcpy(data, data(file, ever), miss);
	    } else {
		char *text;

		memcpy(data, data(file, ever), call);
		text = data;
		text[call] = 0;

		*size = call;

		file(file)->ever = ever + call;
		file(file)->size = miss - call;

		*line = data;

		break;
	    }
	}

	fast = miss;

	pull = file(file)->sf->pull;

	sd = &file(file)->sd;

	miss = 0;

	while (1) {
	    unsigned rate;

	    rate = call - miss;
	    if (rate < EVER_MAX) {
		status = pull(sd, data(file, miss), EVER_MAX - miss);
	    } else {
		status = pull(sd, (char *) data + fast, call - fast);
	    }
	    if (status == -1) {
		if (errno == EINTR) {
		} else {
		    status = READ_CLASS;

		    trans_data->free(trans_data->data, data);

		    if (1) {
			break;
		    }
		}
	    } else {
		if (status) {
		    unsigned ever;

		    ever = status;

		    if (rate < EVER_MAX) {
			miss += ever;
			if (miss + fast < call) {
			} else {
			    char *text;

			    text = data;

			    ever = call - fast;

			    memcpy(text + fast, file(file) + 1, ever);

			    *line = data;
			    *size = call;

			    text[call] = 0;

			    file(file)->ever = ever;
			    file(file)->size = miss - ever;

			    status = 0;

			    break;
			}
		    } else {
			fast += ever;
			if (fast < call) {
			} else {
			    char *text;

			    text = data;

			    *line = data;
			    *size = fast;

			    text[fast] = 0;

			    file(file)->size = 0;

			    status = 0;

			    break;
			}
		    }
		} else {
		    if (fast | miss) {
			char *text;

			text = data;

			if (miss) {
			    memcpy(text + fast, file(file) + 1, miss);
			}

			fast += miss;

			if (fast ^ call) {
			    status = trans_data->mode
				(trans_data->data, &data, fast + 1);
			    if (status) {
				trans_data->free(trans_data->data, data);

				status = MODE_CLASS;

				break;
			    } else {
				text = data;
			    }
			}

			*line = data;
			*size = fast;

			text[fast] = 0;

			file(file)->size = 0;
		    } else {
			status = trans_data->free(trans_data->data, data);
			if (status) {
			    status = FREE_CLASS;
			} else {
			    status = OVER_CLASS;
			}
		    }

		    break;
		}
	    }
	}
    } while (0);

    return status;
}
