/*
 * file.i.g.c
 * Copyright (C) 2008-2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

int
_libx1f4i0_peep_ifile(void *file, unsigned call, int *peep)
{
    int status;

    if (call < EVER_MAX) {
	unsigned ever, miss;

	ever = file(file)->ever;

	miss = file(file)->size;
	if (call < miss) {
	    *peep = (int) *(unsigned char *) data(file, ever + call);

	    status = 0;
	} else {
	    int (*pull)(void *, void *, unsigned);
	    void *sd;

	    if (miss) {
		if (ever) {
		    file(file)->ever = 0;
		    memmove(file(file) + 1, data(file, ever), miss);
		    ever = 0;
		}
	    } else {
		ever = 0;
		file(file)->ever = 0;
	    }

	    pull = file(file)->sf->pull;

	    sd = &file(file)->sd;

	    while (1) {
		status = pull(sd, data(file, miss), EVER_MAX - miss);
		if (status == -1) {
		    if (errno == EINTR) {
		    } else {
			status = READ_CLASS;
			if (1) {
			    break;
			}
		    }
		} else {
		    if (status) {
			miss += status;
			if (call < miss) {
			    *peep = (int) *(unsigned char *) data(file, call);

			    file(file)->size = miss;

			    status = 0;

			    break;
			}
		    } else {
			status = OVER_CLASS;

			file(file)->size = miss;

			if (1) {
			    break;
			}
		    }
		}
	    }
	}
    } else {
	status = PEEP_CLASS;
    }

    return status;
}
