/*
 * file.i.a.c
 * Copyright (C) 2008-2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>
#include <trans.h>

#define __DUMB_SEEK__			0
#define __HOLE_SEEK__			1
#define __ZERO_SEEK__			2

#define __HERE_SEEK__			__ZERO_SEEK__

#define ____HERE_SEEK__			__HERE_SEEK__

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_UNSIGNED_LONG == 4
# define HEAD_ZERO			0x80808080ul
# define LINE_HOLE			0x0a0a0a0aul
# define MISS_HOLE			0x7efefefful
# define MISS_ZERO			0x01010101ul
#else
# define HEAD_ZERO			0x8080808080808080ul
# define LINE_HOLE			0x0a0a0a0a0a0a0a0aul
# define MISS_HOLE			0x7efefefefefefefful
# define MISS_ZERO			0x0101010101010101ul
#endif				/* SIZEOF_UNSIGNED_LONG == 4 */

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

static int find_line(void *, unsigned, unsigned *);
static int slip_data(void *, unsigned, unsigned, unsigned, unsigned *);

static int
find_line(void *data, unsigned size, unsigned *fast)
{
    char *line;
#if ____HERE_SEEK__ == __DUMB_SEEK__
#else
    unsigned slip;
#endif				/* ____HERE_SEEK__ == __DUMB_SEEK__ */

    line = data;

#if ____HERE_SEEK__ == __DUMB_SEEK__
    do {
	if (*line == 10) {
	    break;
	} else {
	    line++;
	    size--;
	}
    } while (size);
#else
    slip =
	(SIZEOF_UNSIGNED_LONG
	 - ((integral_q) data & (SIZEOF_UNSIGNED_LONG - 1)))
	& (SIZEOF_UNSIGNED_LONG - 1);
    if (slip) {
	if (size < slip) {
	    slip = size;
	}

	size -= slip;

	do {
	    if (*line == 10) {
		size = 0;

		break;
	    } else {
		line++;
		slip--;
	    }
	} while (slip);
    }
#endif				/* ____HERE_SEEK__ == __DUMB_SEEK__ */

#if ____HERE_SEEK__ == __ZERO_SEEK__
    if (size) {
	slip = size / SIZEOF_UNSIGNED_LONG;
	if (slip) {
	    unsigned long *deck;

	    deck = (unsigned long *) line;

	    do {
		unsigned long this;

		this = *deck ^ LINE_HOLE;
		if (((this - MISS_ZERO) & ~this) & HEAD_ZERO) {
		    size = (size & (SIZEOF_UNSIGNED_LONG - 1))
			+ slip * SIZEOF_UNSIGNED_LONG;

		    line = (char *) deck;

		    break;
		} else {
		    slip--;
		    if (slip) {
			deck++;
		    } else {
			size = size & (SIZEOF_UNSIGNED_LONG - 1);

			line = (char *) (deck + 1);

			break;
		    }
		}
	    } while (1);
	}

	if (size) {
	    do {
		if (*line == 10) {
		    break;
		} else {
		    line++;
		    size--;
		}
	    } while (size);
	}
    }
#elif __HERE_SEEK__ == __HOLE_SEEK__
    if (size) {
	slip = size / SIZEOF_UNSIGNED_LONG;
	if (slip) {
	    unsigned long *deck;

	    deck = (unsigned long *) line;

	    do {
		unsigned long this;

		this = *deck ^ LINE_HOLE;
		if (((this + MISS_HOLE) ^ ~this) & ~MISS_HOLE) {
		    line = (char *) deck;

		    if (*line == 10) {
			size = 0;
			if (1) {
			    break;
			}
		    }

		    line++;

		    if (*line == 10) {
			size = 0;
			if (1) {
			    break;
			}
		    }

		    line++;

		    if (*line == 10) {
			size = 0;
			if (1) {
			    break;
			}
		    }

		    line++;

		    if (*line == 10) {
			size = 0;
			if (1) {
			    break;
			}
		    }

# if SIZEOF_UNSIGNED_LONG == 8
		    line++;

		    if (*line == 10) {
			size = 0;
			if (1) {
			    break;
			}
		    }

		    line++;

		    if (*line == 10) {
			size = 0;
			if (1) {
			    break;
			}
		    }

		    line++;

		    if (*line == 10) {
			size = 0;
			if (1) {
			    break;
			}
		    }

		    line++;

		    if (*line == 10) {
			size = 0;
			if (1) {
			    break;
			}
		    }
# endif				/* SIZEOF_UNSIGNED_LONG == 8 */

		    deck++;

		    slip--;
		} else {
		    slip--;
		    if (slip) {
			deck++;
		    } else {
			size = size & (SIZEOF_UNSIGNED_LONG - 1);

			line = (char *) (deck + 1);

			break;
		    }
		}
	    } while (1);
	}

	if (size) {
	    do {
		if (*line == 10) {
		    break;
		} else {
		    line++;
		    size--;
		}
	    } while (size);
	}
    }
#endif				/* ____HERE_SEEK__ == __ZERO_SEEK__ */

    *fast = line - (char *) data;

    return 0;
}


static int
slip_data(void *file, unsigned miss, unsigned ever, unsigned fast,
	  unsigned *size)
{
    if (0) {
    } else {
	*size = fast;

	fast++;

	file(file)->ever = ever + fast;
	file(file)->size = miss - fast;
    }

    return 0;
}


int
_libx1f4i0_slip_ifile(void *file, unsigned *size)
{
    int status;

    do {
	unsigned miss;

	miss = file(file)->size;
	if (miss) {
	    unsigned ever, fast;

	    ever = file(file)->ever;

	    find_line(data(file, ever), miss, &fast);
	    if (fast < miss) {
		status = slip_data(file, miss, ever, fast, size);

		break;
	    }
	}

	if (1) {
	    if (0) {
	    } else {
		int (*pull)(void *, void *, unsigned);
		void *sd;

		pull = file(file)->sf->pull;

		sd = &file(file)->sd;

		while (1) {
		    status = pull(sd, file(file) + 1, EVER_MAX);
		    if (status == -1) {
			if (errno == EINTR) {
			} else {
			    status = READ_CLASS;
			    if (1) {
				break;
			    }
			}
		    } else {
			if (status) {
			    unsigned ever, fast;

			    ever = status;

			    find_line(file(file) + 1, ever, &fast);
			    if (fast < ever) {
				miss += fast;

				*size = miss;

				fast++;

				ever -= fast;

				file(file)->ever = fast;
				file(file)->size = ever;

				status = 0;

				break;
			    } else {
				miss = miss + ever;
			    }
			} else {
			    *size = miss;

			    file(file)->size = 0;

			    if (miss) {
			    } else {
				status = OVER_CLASS;
			    }

			    break;
			}
		    }
		}
	    }
	}
    } while (0);

    return status;
}
