/*
 * file.i.7.c
 * Copyright (C) 2008-2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <stddef.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>
#include <trans.h>

#define DONE_CLASS			144
#define MISS_CLASS			169

#define DECK_SET			4

#define DECK_MAX			(1 << DECK_SET)

#define true(e)				e

#define fix(m) \
    ((m) < DECK_MAX ? (m) : DECK_MAX)
#undef fix
#define DECK_FIX \
    ((((1 << DECK_SET) - (sizeof(struct deck_type) & ((1 << DECK_SET) - 1)))  \
      & ((1 << DECK_SET) - 1)) + (1 << DECK_SET))
#define fix(m) \
    ((m) < DECK_FIX ? (m) : DECK_FIX)

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

#undef isodigit
#define isodigit(c) \
    (0x2f < (c) && (c) < 0x38)

typedef struct deck_type {
    struct deck_type *deck_data;
    unsigned bits, size;
} deck_type;

static int case_deck(struct deck_type **, struct deck_type **, unsigned *,
		     unsigned, void *, struct trans_type *);
static int ever_deck(struct deck_type **, unsigned *, unsigned, void *,
		     struct trans_type *);
static int fast_deck(struct deck_type **, unsigned *, unsigned, void *,
		     struct trans_type *);
static int fast_slip(void **, unsigned, void *);
static int fast_tail(unsigned *, unsigned, void *);

static int
case_deck(struct deck_type **head, struct deck_type **deck, unsigned *slip,
	  unsigned miss, void *data, struct trans_type *trans_data)
{
    int status;
    unsigned left;

    left = 0;

    while (1) {
	unsigned fast;

	status = ever_deck(deck, &fast, miss, data, trans_data);
	if (status == LINK_CLASS) {
	    break;
	} else {
	    left += fast;
	    miss -= fast;

	    data = (char *) data + fast;

	    if (1) {
		if (*head) {
		} else {
		    *head = *deck;
		}
	    }

	    if (status == MISS_CLASS) {
	    } else {
		*slip = left;
		if (1) {
		    break;
		}
	    }
	}
    }

    return status;
}


static int
ever_deck(struct deck_type **deck, unsigned *slip, unsigned miss,
	  void *data, struct trans_type *trans_data)
{
    char *s;
    int status;
    unsigned i;

    s = data;

    i = miss;
    while (i) {
	int c;

	c = *(unsigned char *) s;
	if (c == 9) {
	    s++;
	    i--;
	} else {
	    if (c == 32) {
		i--;
		s++;
	    } else {
		if (c == 92) {
		    if (i ^ 1) {
			if (*(unsigned char *) (s + 1) == 10) {
			    i -= 2;
			    s += 2;
			} else {
			    break;
			}
		    } else {
			break;
		    }
		} else {
		    break;
		}
	    }
	}
    }

    if (i ^ miss) {
	struct deck_type *deck_data;

	deck_data = *deck;
	if (deck_data) {
	    deck_data->bits |= 1;
	}
    }

    if (i) {
	if (*(unsigned char *) s == 10) {
	    struct deck_type *deck_data;

	    status = 1;

	    deck_data = *deck;
	    if (deck_data) {
		deck_data->bits |= 1;
	    }
	} else {
	    int c;

	    c = *(unsigned char *) (s + 0);
	    if (c == 92) {
		if (i == 1) {
		    status = 0;
		} else {
		    int e;

		    e = *(unsigned char *) (s + 1);
		    if (isodigit(e)) {
			if (i == 2) {
			    status = 0;
			} else {
			    int o;

			    o = *(unsigned char *) (s + 2);
			    if (isodigit(o)) {
				if (i == 3) {
				    status = 0;
				} else {
				    if (1) {
					status = 2;
				    }
				}
			    } else {
				status = 2;
			    }
			}
		    } else {
			status = 2;
		    }
	        }
	    } else {
		status = 2;
	    }
	}
    } else {
	status = 0;
    }

    if (status) {
	if (status == 1) {
	    status = DONE_CLASS;
	    if (1) {
		*slip = miss - i + 1;
	    }
	} else {
	    unsigned none;

	    status = fast_deck(deck, &none, fix(i), s, trans_data);
	    if (0) {
	    } else {
		if (status == LINK_CLASS) {
		    *slip = 0;
		} else {
		    *slip = none + miss - i;
		    if (status) {
		    } else {
			status = MISS_CLASS;
		    }
		}
	    }
	}
    } else {
	*slip = miss - i;
    }

    return status;
}


static int
fast_deck(struct deck_type **deck, unsigned *slip, unsigned miss,
	  void *data, struct trans_type *trans_data)
{
    int status;
    void *line;

    status = trans_data->link
	(trans_data->data, &line, sizeof(struct deck_type) + miss);
    if (status) {
	status = LINK_CLASS;
    } else {
	struct deck_type *deck_data;

	deck_data = *deck;
	if (deck_data) {
	    deck_data->deck_data = line;
	}

	deck_data = line;

	*deck = deck_data;

	if (1) {
	    char *s, *t;
	    unsigned bits = 0, i;

	    s = data;
	    t = (void *) (deck_data + 1);

	    i = miss;
	    while (i) {
		int c;

		c = *(unsigned char *) s;
		if (c != 92) {
		    i--;
		    if (c == 10) {
			bits = 1;
			status = DONE_CLASS;
			break;
		    } else {
			if (c == 9) {
			    bits = 1;
			    status = MISS_CLASS;
			    break;
			} else {
			    if (c == 32) {
				bits = 1;
				status = MISS_CLASS;
				break;
			    } else {
				s++;
				*t++ = c;
			    }
			}
		    }
		} else {
		    i--;
		    if (i) {
		    } else {
			i = 1;
			if (1) {
			    break;
			}
		    }
		    i--;
		    s++;
		    c = *(unsigned char *) s;
		    s++;
		    if (isodigit(c)) {
			if (i) {
			    int e;

			    e = *(unsigned char *) s;
			    if (isodigit(e)) {
				i--;
				if (i) {
				    int o;

				    s++;
				    o = *(unsigned char *) s;
				    if (isodigit(o)) {
					i--;
					s++;
					*t++ = ((c - 0x30) << 6)
					    + ((e - 0x30) << 3) + (o - 0x30);
				    } else {
					*t++ = ((c - 0x30) << 3) + (e - 0x30);
				    }
				} else {
				    i = 3;
				    if (1) {
					break;
				    }
				}
			    } else {
				*t++ = c - 0x30;
			    }
			} else {
			    i = 2;
			    if (1) {
				 break;
			    }
			}
		    } else {
			switch (c) {
			case 0141:
			    *t++ = 7;
			    break;
			case 0142:
			    *t++ = 8;
			    break;
			case 0146:
			    *t++ = 12;
			    break;
			case 0156:
			    *t++ = 10;
			    break;
			case 0162:
			    *t++ = 13;
			    break;
			case 0164:
			    *t++ = 9;
			    break;
			case 0166:
			    *t++ = 11;
			    break;
			default:
			    if (c == 10) {
			    } else {
				*t++ = c;
			    }
			}
		    }
		}
	    }

	    miss -= i;

	    *slip = miss;

	    deck_data->bits = bits;

	    miss = t - (char *) (deck_data + 1);

	    if (1) {
		deck_data->size = miss;
	    }
	}
    }

    return status;
}


static int
fast_slip(void **slip, unsigned tail, void *data)
{
    char *fast, *miss;

    miss = data;

    fast = *slip;

    if (tail == 2) {
	*fast = *(unsigned char *) (miss + 1) - 0x30;
    } else {
	if (true(tail == 3)) {
	    *fast = ((*(unsigned char *) (miss + 1) - 0x30) << 3)
		+ (*(unsigned char *) (miss + 2) - 0x30);
	}
    }

    *slip = fast + 1;

    return 0;
}


static int
fast_tail(unsigned *slip, unsigned tail, void *data)
{
    *slip = tail == 1 ? 0 : 1;

    return 0;
}


int
_libx1f4i0_list_ifile(void *file, void *list, unsigned *size, unsigned post,
		      int (*push) (void *, void *),
		      struct trans_type *trans_data)
{
    int status;
    struct deck_type *deck_data = NULL, *deck_slip = NULL;
    unsigned ever, miss, tail = 0;

    do {
	int (*pull)(void *, void *, unsigned);
	void *sd;

	miss = file(file)->size;
	if (miss) {
	    unsigned slip;

	    ever = file(file)->ever;

	    status = case_deck
		(&deck_data, &deck_slip, &slip, miss, data(file, ever),
		 trans_data);
	    if (status) {
		if (status == DONE_CLASS) {
		    ever += slip;
		    miss -= slip;
		}

		break;
	    } else {
		miss -= slip;
		if (miss) {
		    memmove(file(file) + 1, data(file, ever + slip), miss);
		}

		ever = 0;
	    }
	} else {
	    ever = 0;

	    deck_slip = NULL;
	}

	pull = file(file)->sf->pull;

	sd = &file(file)->sd;

	while (1) {
	    if (0) {
	    } else {
		status = pull(sd, data(file, ever + miss), EVER_MAX - miss);
		if (status == -1) {
		    if (errno == EINTR) {
		    } else {
			status = READ_CLASS;
			if (1) {
			    break;
			}
		    }
		} else {
		    if (status) {
			if (0) {
			} else {
			    unsigned slip;

			    miss += status;

			    status = case_deck
				(&deck_data, &deck_slip, &slip, miss,
				 data(file, ever), trans_data);
			    if (status) {
				if (status == DONE_CLASS) {
				    ever += slip;
				    miss -= slip;
				}

				break;
			    } else {
				miss -= slip;
				if (miss) {
				    memmove(file(file) + 1,
					    data(file, ever + slip), miss);
				}

				ever = 0;
			    }
			}
		    } else {
			if (deck_data || miss) {
			    tail = miss;

			    status = DONE_CLASS;
			} else {
			    status = OVER_CLASS;
			}
			if (1) {
			    break;
			}
		    }
		}
	    }
	}
    } while (0);

    if (deck_data) {
	deck_slip->deck_data = NULL;
    }

    if (status != DONE_CLASS) {
    } else {
	if (!deck_data && !tail) {
	    status = 0;

	    *size = 0;

	    file(file)->ever = ever;
	    file(file)->size = miss;
	} else {
	    struct deck_type *deck_this;
	    unsigned last = 0;

	    deck_this = deck_data;
	    while (1) {
		if (post == 1) {
		    if (1) {
			unsigned bits, fast = 0, flat = 0, slip;
			void *text;

			if (tail) {
			    fast_tail(&slip, tail, data(file, ever));
			} else {
			    slip = 0;
			}

			bits = 0;

			deck_slip = deck_this;
			while (deck_slip) {
			    fast += flat & bits;
			    fast += deck_slip->size;
			    flat = 1;
			    bits = deck_slip->bits;
			    deck_slip = deck_slip->deck_data;
			}

			status = trans_data->link
			    (trans_data->data, &text, fast + slip + 1);
			if (status) {
			    status = LINK_CLASS;
			} else {
			    void *data;

			    data = text;

			    flat = 0;

			    bits = 0;

			    deck_slip = deck_this;
			    while (deck_slip) {
				unsigned size;

				if (flat & bits) {
				    *(char *) data = 32;
				    data = (char *) data + 1;
				}
				flat = 1;
				bits = deck_slip->bits;
				size = deck_slip->size;
				memcpy(data, deck_slip + 1, size);
				deck_slip = deck_slip->deck_data;
				data = (char *) data + size;
			    }

			    if (slip) {
				fast_slip(&data, tail, data(file, ever));
			    }

			    *(char *) data = 0;

			    status = push(list, text);
			    if (status) {
				status = CALL_CLASS;
				if (1) {
				    trans_data->free(trans_data->data, text);
				}
			    } else {
				*size = last + fast + slip;

				file(file)->ever = ever;
				file(file)->size = miss - tail;
			    }
			}

			break;
		    }
		} else {
		    if (post) {
			post--;
		    }

		    if (1) {
			unsigned fast = 0, flat, slip;
			void *text;

			deck_slip = deck_this;
			while (deck_slip) {
			    fast += deck_slip->size;
			    if (deck_slip->bits & 1) {
				break;
			    } else {
				deck_slip = deck_slip->deck_data;
			    }
			}

			if (deck_slip) {
			    flat = 0;
			    slip = 0;
			} else {
			    flat = tail;
			    if (tail) {
				fast_tail(&slip, tail, data(file, ever));
				if (1) {
				    tail = 0;
				}
			    } else {
				slip = 0;
			    }
			}

			status = trans_data->link
			    (trans_data->data, &text, fast + slip + 1);
			if (status) {
			    status = LINK_CLASS;
			    if (1) {
				break;
			    }
			} else {
			    void *data;

			    data = text;

			    deck_slip = deck_this;
			    while (deck_slip) {
				unsigned size;

				size = deck_slip->size;
				memcpy(data, deck_slip + 1, size);
				data = (char *) data + size;
				if (deck_slip->bits & 1) {
				    deck_slip = deck_slip->deck_data;
				    if (1) {
					break;
				    }
				} else {
				    deck_slip = deck_slip->deck_data;
				}
			    }

			    deck_this = deck_slip;

			    if (slip) {
				fast_slip(&data, flat, data(file, ever));
			    }

			    *(char *) data = 0;

			    status = push(list, text);
			    if (status) {
				status = CALL_CLASS;

				trans_data->free(trans_data->data, text);

				if (1) {
				    break;
				}
			    } else {
				last += fast + slip;

				if (deck_this) {
				} else {
				    if (tail) {
				    } else {
					*size = last;

					file(file)->ever = ever;
					file(file)->size = miss - flat;
					if (1) {
					    break;
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    if (deck_data) {
	int excess;

	while (1) {
	    deck_slip = deck_data->deck_data;
	    excess = trans_data->free(trans_data->data, deck_data);
	    if (excess) {
		if (status) {
		} else {
		    status = FREE_CLASS;
		}

		break;
	    } else {
		if (deck_slip) {
		    deck_data = deck_slip->deck_data;
		    excess = trans_data->free(trans_data->data, deck_slip);
		    if (excess) {
			if (status) {
			} else {
			    status = FREE_CLASS;
			}

			break;
		    } else {
			if (deck_data) {
			} else {
			    break;
			}
		    }
		} else {
		    break;
		}
	    }
	}
    }

    return status;
}
