/*
 * file.i.4.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>
#include <trans.h>

#define __DUMB_SEEK__			0
#define __ZERO_SEEK__			2

#define __HERE_SEEK__			__ZERO_SEEK__

#define ____HERE_SEEK__			__HERE_SEEK__

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_UNSIGNED_LONG == 4
# define HEAD_ZERO			0x80808080ul
# define MISS_ZERO			0x01010101ul
#else
# define HEAD_ZERO			0x8080808080808080ul
# define MISS_ZERO			0x0101010101010101ul
#endif				/* SIZEOF_UNSIGNED_LONG == 4 */

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct eifile_type *) (file))

static int copy_data(void *, unsigned, unsigned, unsigned, void **, unsigned *,
		     struct trans_type *);
static int find_line(void *, unsigned, unsigned *);

static int
copy_data(void *file, unsigned miss, unsigned ever, unsigned fast, void **line,
	  unsigned *size, struct trans_type *trans_data)
{
    int status;
    void *data;

    status = trans_data->link(trans_data->data, &data, fast + 1);
    if (status) {
	status = LINK_CLASS;
    } else {
	char *text;

	memcpy(data, data(file, ever), fast);
	text = data;
	text[fast] = 0;

	*size = fast;

	fast++;

	file(file)->ever = ever + fast;
	file(file)->size = miss - fast;

	*line = data;
    }

    return status;
}


static int
find_line(void *data, unsigned size, unsigned *fast)
{
    char *line;
#if ____HERE_SEEK__ == __DUMB_SEEK__
#else
    unsigned slip;
#endif				/* ____HERE_SEEK__ == __DUMB_SEEK__ */

    line = data;

#if ____HERE_SEEK__ == __DUMB_SEEK__
    do {
	if (*line) {
	    line++;
	    size--;
	} else {
	    break;
	}
    } while (size);
#else
    slip =
	(SIZEOF_UNSIGNED_LONG
	 - ((integral_q) data & (SIZEOF_UNSIGNED_LONG - 1)))
	& (SIZEOF_UNSIGNED_LONG - 1);
    if (slip) {
	if (size < slip) {
	    slip = size;
	}

	size -= slip;

	do {
	    if (*line) {
		line++;
		slip--;
	    } else {
		size = 0;

		break;
	    }
	} while (slip);
    }
#endif				/* ____HERE_SEEK__ == __DUMB_SEEK__ */

#if ____HERE_SEEK__ == __ZERO_SEEK__
    if (size) {
	slip = size / SIZEOF_UNSIGNED_LONG;
	if (slip) {
	    unsigned long *deck;

	    deck = (unsigned long *) line;

	    do {
		unsigned long this;

		this = *deck;
		if (((this - MISS_ZERO) & ~this) & HEAD_ZERO) {
		    size = (size & (SIZEOF_UNSIGNED_LONG - 1))
			+ slip * SIZEOF_UNSIGNED_LONG;

		    line = (char *) deck;

		    break;
		} else {
		    slip--;
		    if (slip) {
			deck++;
		    } else {
			size = size & (SIZEOF_UNSIGNED_LONG - 1);

			line = (char *) (deck + 1);

			break;
		    }
		}
	    } while (1);
	}

	if (size) {
	    do {
		if (*line) {
		    line++;
		    size--;
		} else {
		    break;
		}
	    } while (size);
	}
    }
#endif				/* ____HERE_SEEK__ == __ZERO_SEEK__ */

    *fast = line - (char *) data;

    return 0;
}


int
_libx1f4i0_case_ifile(void *file, void **line, unsigned *size,
		      struct trans_type *trans_data)
{
    int status;

    do {
	int (*pull)(void *, void *, unsigned);
	unsigned ever, fast, miss;
	void *sd;

	miss = file(file)->size;
	if (miss) {
	    ever = file(file)->ever;

	    find_line(data(file, ever), miss, &fast);
	    if (fast < miss) {
		status = copy_data
		    (file, miss, ever, fast, line, size, trans_data);

		break;
	    } else {
		if (ever) {
		    memmove(file(file) + 1, data(file, ever), miss);
		}
	    }
	} else {
	    ever = 0;
	}

	pull = file(file)->sf->pull;

	sd = &file(file)->sd;

	if (miss < EVER_MAX) {
	    ever = miss;

	    while (1) {
		status = pull(sd, data(file, miss), EVER_MAX - miss);
		if (status == -1) {
		    if (errno == EINTR) {
		    } else {
			status = READ_CLASS;
			if (1) {
			    break;
			}
		    }
		} else {
		    if (status) {
			unsigned ever, mind;

			ever = status;

			mind = miss;

			find_line(data(file, miss), ever, &fast);
			miss = miss + status;
			if (miss < EVER_MAX) {
			    if (fast < ever) {
				fast += mind;
				status = 0;
				if (1) {
				    break;
				}
			    }
			} else {
			    fast += mind;
			    status = 0;
			    if (1) {
				break;
			    }
			}
		    } else {
			if (ever == miss) {
			    status = OVER_CLASS;
			    if (1) {
				break;
			    }
			} else {
			    status = 0;
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }

	    if (status) {
		break;
	    }

	    if (fast < miss) {
		status = copy_data
		    (file, miss, 0, fast, line, size, trans_data);

		break;
	    } else {
		if (miss == EVER_MAX) {
		} else {
		    status = copy_data
			(file, miss + 1, 0, miss, line, size, trans_data);

		    break;
		}
	    }
	}

	if (1) {
	    void *data;

	    status = trans_data->link
		(trans_data->data, &data, (EVER_MAX << 1) + 1);
	    if (status) {
		status = LINK_CLASS;
	    } else {
		unsigned slip;

		slip = miss + EVER_MAX;

		while (1) {
		    status = pull(sd, (char *) data + miss, slip - miss);
		    if (status == -1) {
			if (errno == EINTR) {
			} else {
			    status = READ_CLASS;
			    if (1) {
				break;
			    }
			}
		    } else {
			if (status) {
			    ever = status;

			    find_line((char *) data + miss, ever, &fast);
			    if (fast < ever) {
				char *text;

				memcpy(data, file(file) + 1, EVER_MAX);

				miss += fast;

				*line = data;
				*size = miss;

				text = (char *) data + miss;
				*text = 0;

				ever -= fast + 1;

				file(file)->ever = 0;
				file(file)->size = ever;

				memcpy(file(file) + 1, text + 1, ever);

				status = 0;

				break;
			    } else {
				miss = miss + ever;
			    }
			} else {
			    char *text;

			    memcpy(data, file(file) + 1, EVER_MAX);

			    *line = data;
			    *size = miss;

			    text = data;
			    text[miss] = 0;

			    file(file)->size = 0;

			    break;
			}
		    }

		    if (miss == slip) {
			slip += EVER_MAX;

			status = trans_data->mode
			    (trans_data->data, &data, slip + 1);
			if (status) {
			    trans_data->free(trans_data->data, data);

			    status = MODE_CLASS;

			    break;
			}
		    }
		}
	    }
	}
    } while (0);

    return status;
}
