/*
 * file.h
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_file_H__
#define __LIBx1f4_file_H__

#include <sys/types.h>

#include <trans.h>

/*
 * file error definitions
 */
#define FILE_CALL_CLASS			-129
#define FILE_FINE_CLASS			-130
#define FILE_FREE_CLASS			-131
#define FILE_HALF_CLASS			-132
#define FILE_LINK_CLASS			-133
#define FILE_LOSE_CLASS			-134
#define FILE_MODE_CLASS			-135
#define FILE_OPEN_CLASS			-136
#define FILE_OVER_CLASS			-137
#define FILE_PEEP_CLASS			-138
#define FILE_PUSH_CLASS			-139
#define FILE_READ_CLASS			-140
#define FILE_SEEK_CLASS			-141
#define FILE_ZERO_CLASS			-142

#define _libx1f4i0_shut_ifile		_libx1f4i0_lose_ifile

extern int _libx1f4i0_case_ifile
    (void *, void **, unsigned *, struct trans_type *);
extern int _libx1f4i0_ever_ifile(void *, int *);
extern int _libx1f4i0_ever_ofile(void *, int *);
extern int _libx1f4i0_fast_ifile
    (void *, unsigned *, void **, unsigned *, struct trans_type *);
extern int _libx1f4i0_fine_ifile(void *);
extern int _libx1f4i0_fine_ofile(void *);
extern int _libx1f4i0_fset_ifile(void *, int);
extern int _libx1f4i0_fset_ofile(void *, int);
extern int _libx1f4i0_head_ifile
    (void *, void **, unsigned *, struct trans_type *);
extern int _libx1f4i0_here_ofile(void *);
extern int _libx1f4i0_land_ifile(void *, void *, void *);
extern int _libx1f4i0_land_ofile(void *, void *, void *);
extern int _libx1f4i0_lead_ifile
    (void *, void **, unsigned *, struct trans_type *);
extern int _libx1f4i0_line_ifile
    (void *, void **, unsigned *, struct trans_type *);
extern int _libx1f4i0_list_ifile
    (void *, void *, unsigned *, unsigned,
     int (*) (void *, void *), struct trans_type *);
extern int _libx1f4i0_lose_ifile(void *);
extern int _libx1f4i0_lose_ofile(void *);
extern int _libx1f4i0_mind_ifile(unsigned *);
extern int _libx1f4i0_near_ifile
    (void *, unsigned *, void **, unsigned *, struct trans_type *);
extern int _libx1f4i0_open_ifile(void *, const char *, unsigned, unsigned);
extern int _libx1f4i0_open_ofile(void *, const char *, unsigned, unsigned);
extern int _libx1f4i0_peek_ifile(void *, int *);
extern int _libx1f4i0_peep_ifile(void *, unsigned, int *);
extern int _libx1f4i0_pick_ifile(void *, int *);
extern int _libx1f4i0_push_ofile(void *, void *, unsigned);
extern int _libx1f4i0_read_ifile
    (void *, void **, unsigned *, unsigned, struct trans_type *);
extern int _libx1f4i0_seek_ifile(void *, off_t, int);
extern int _libx1f4i0_seek_ofile(void *, off_t, int);
extern int _libx1f4i0_shut_ofile(void *);
extern int _libx1f4i0_side_ifile(void *, unsigned *, unsigned *);
extern int _libx1f4i0_size_ifile(unsigned *);
extern int _libx1f4i0_size_ofile(unsigned *);
extern int _libx1f4i0_skip_ifile(void *, unsigned, unsigned *);
extern int _libx1f4i0_slip_ifile(void *, unsigned *);
extern int _libx1f4i0_tell_ifile(void *, off_t *);
extern int _libx1f4i0_tell_ofile(void *, off_t *);
extern int _libx1f4i0_word_ifile
    (void *, void **, unsigned *, struct trans_type *);

#endif				/* __LIBx1f4_file_H__ */
