/*
 * file-types.h
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_file_types_H__
#define __LIBx1f4_file_types_H__

#include <sys/types.h>

#include <trans.h>

typedef struct adfile_type {
    unsigned slip;
    void *data, *text;
} adfile_type;

typedef struct edfile_type {
    unsigned slip;
    void *data, *text;
} edfile_type;

typedef union sdfile_type {
    int fa;
    struct adfile_type fb;
    struct edfile_type fc;
} sdfile_type;

typedef struct sffile_type {
    int (*fine)(void *), (*lose)(void *), (*pull)(void *, void *, unsigned),
	(*push)(void *, void *, unsigned);
    off_t (*seek)(void *, off_t, int);
} sffile_type;

typedef struct aofile_type {
    const struct sffile_type *sf;
    union sdfile_type sd;
    unsigned ever, size;
} aofile_type;

typedef struct eifile_type {
    const struct sffile_type *sf;
    union sdfile_type sd;
    unsigned ever, size;
} eifile_type;

#endif				/* __LIBx1f4_file_types_H__ */
