/*
 * e4ll.f.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4ll-defs.h>
#include <e4ll-types.h>

static int fini_e4ll(struct e4less_type *);
static int flat_e4ll(struct e4less_type *);

static int
fini_e4ll(struct e4less_type *e4less_data)
{
    int (*free) (void *, void *), status;
    void *data;

    data = e4less_data->link_m.data;
    free = e4less_data->link_m.free;

    if (0) {
    } else {
	status = free(data, e4less_data);
	if (status) {
	    status = FREE_ERROR;
	}
    }

    return status;
}


static int
flat_e4ll(struct e4less_type *e4less_data)
{
    int status;
    struct e4node_type *e4node_data;

    e4node_data = e4less_data->link_c.node;
    if (e4node_data) {
	int (*fini) (void **, void *), (*free) (void *, void *);
	void *data, *text;

	data = e4less_data->link_m.data;
	free = e4less_data->link_m.free;

	fini = e4less_data->link_a.fini;
	text = e4less_data->link_a.data;

	do {
	    void *link;

	    link = e4node_data->link;
	    if (link) {
		status = fini(&link, data);
		if (status) {
		    status = FINI_ERROR;
		    break;
		}
	    }
	    {
		struct e4node_type *post_e4node;

		post_e4node = e4node_data->e4node_data;

		status = free(data, e4node_data);
		if (status) {
		    status = FREE_ERROR;

		    e4node_data->link = NULL;
		    e4less_data->link_c.node = e4node_data;

		    break;
		} else {
		    if (post_e4node) {
			e4node_data = post_e4node;
		    } else {
			e4less_data->link_c.node = NULL;

			break;
		    }
		}
	    }
	} while (1);
    } else {
	status = 0;
    }

    return status;
}


int
x1f4_fini_e4ll(void **e4less)
{
    int excess, status;

    status = flat_e4ll(*e4less);

    excess = fini_e4ll(*e4less);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}
