/*
 * e4ll.4.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4ll-defs.h>
#include <e4ll-types.h>
#include <e4.h>

int
x1f4_lock_e4ll(void *e4less, const struct x1f4_function_type *function_data)
{
    int status;
    struct e4less_type *e4less_data;
    struct e4node_type *e4node_data, *e4node_swap;

    e4less_data = e4less;

    e4node_swap = e4less_data->link_c.node;

    e4node_data = e4node_swap->e4node_data;

    status = e4less_data->link_a.swap(e4node_data->link, e4node_swap->link);
    if (status) {
	status = SWAP_ERROR;
    } else {
	status = e4less_data->link_a.fini
	    (&e4node_data->link, e4less_data->link_a.data);
	if (status) {
	    status = FINI_ERROR;
	} else {
	    e4node_swap->e4node_data = e4node_data->e4node_data;

	    status = e4less_data->link_m.free
		(e4less_data->link_m.data, e4node_data);
	    if (status) {
		status = FREE_ERROR;
	    }
	}
    }

    return status;
}
