/*
 * e4ll.0.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-m.0.h>
#include <e4ll-defs.h>
#include <e4ll-types.h>
#include <xalist.h>

static int init_e4ll(struct e4less_type *, unsigned, struct screen_type *);
static int link_e4ll(struct e4less_type *);

static int
init_e4ll(struct e4less_type *e4less_data, unsigned bits,
	  struct screen_type *screen_data)
{
    if (bits & MISSLINK_LINK) {
	e4less_data->link_a.data = screen_data->link_a.data;
	e4less_data->link_a.deck = screen_data->link_a.deck;
	e4less_data->link_a.fini = screen_data->link_a.fini;
	e4less_data->link_a.free = screen_data->link_a.free;
	e4less_data->link_a.init = screen_data->link_a.init;
	e4less_data->link_a.link = screen_data->link_a.link;
	e4less_data->link_a.mode = screen_data->link_a.mode;
	e4less_data->link_a.pick = screen_data->link_a.pick;
	e4less_data->link_a.slip = screen_data->link_a.slip;
	e4less_data->link_a.swap = screen_data->link_a.swap;
    } else {
	e4less_data->link_a.data = NULL;
	e4less_data->link_a.deck = _libx1f4i0_deck_xalist;
	e4less_data->link_a.fini = _libx1f4i0_fini_xalist;
	e4less_data->link_a.free = _libx1f4i0_free_xalist;
	e4less_data->link_a.init = _libx1f4i0_init_xalist;
	e4less_data->link_a.link = _libx1f4i0_link_xalist;
	e4less_data->link_a.mode = _libx1f4i0_mode_xalist;
	e4less_data->link_a.pick = NULL;
	e4less_data->link_a.slip = NULL;
	e4less_data->link_a.swap = _libx1f4i0_swap_xalist;
    }

    if (bits & RESOURCE_LINK) {
	e4less_data->link_m.data = screen_data->link_m.data;
	e4less_data->link_m.free = screen_data->link_m.free;
	e4less_data->link_m.link = screen_data->link_m.link;
	e4less_data->link_m.mode = screen_data->link_m.mode;
    } else {
	e4less_data->link_m.data = NULL;
	e4less_data->link_m.free = _x1f4_e4_free_data;
	e4less_data->link_m.link = _x1f4_e4_link_data;
	e4less_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	e4less_data->link_e.data = screen_data->link_e.data;
	e4less_data->link_e.line = screen_data->link_e.line;
	e4less_data->link_e.post = screen_data->link_e.post;
	e4less_data->link_e.push = screen_data->link_e.push;
    } else {
	e4less_data->link_e.data = NULL;
	e4less_data->link_e.line = NULL;
	e4less_data->link_e.post = NULL;
	e4less_data->link_e.push = NULL;
    }

    return link_e4ll(e4less_data);
}


static int
link_e4ll(struct e4less_type *e4less_data)
{
    int status;
    void *node;

    status = e4less_data->link_m.link
	(e4less_data->link_m.data, &node, sizeof(struct e4node_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	struct e4node_type *e4node_data;

	e4node_data = node;

	status = e4less_data->link_a.init
	    (&e4node_data->link, e4less_data->link_a.data);
	if (status) {
	    status = INIT_ERROR;

	    e4less_data->link_m.free(e4less_data->link_m.data, node);
	} else {
	    e4less_data->link_c.node = node;

	    e4node_data->e4node_data = NULL;
	}
    }

    return status;
}


int
x1f4_init_e4ll(void **e4less, unsigned bits, struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *e4ll, *text;

    if (bits & RESOURCE_LINK) {
	link = screen_data->link_m.link;
	text = screen_data->link_m.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &e4ll, sizeof(struct e4less_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_e4ll(e4ll, bits, screen_data);
	if (status) {
	    if (bits & RESOURCE_LINK) {
		screen_data->link_m.free(text, e4ll);
	    } else {
		_x1f4_e4_free_data(text, e4ll);
	    }
	} else {
	    *e4less = e4ll;
	}
    }

    return status;
}
