/*
 * e4jack.h
 * Copyright (C) 2010-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4jack_H__
#define __LIBx1f4_e4jack_H__

#include <dt.h>

/*
 * error definitions
 */
#define X1f4_E4JACK_ALLOC_ERROR		1
#define X1f4_E4JACK_PARSE_ERROR		2

typedef struct x1f4_ejrecord_type {
    union {
	struct {
	    const char *name;
	    unsigned size;
	} misstype;
    } data;
    unsigned code;
} x1f4_ejrecord_type;

extern int x1f4_fast_e4jack
    (const struct x1f4_datatype_type *, const char *, unsigned, int *,
     const struct x1f4_datatype_type **);
extern int x1f4_lock_e4jack
    (const char *, unsigned, int *);
extern int x1f4_pick_e4jack
    (int, int *, unsigned *, unsigned *, const char **, const char **, int,
     int, void *, void (*) (const char **), const struct x1f4_datatype_type *,
     const struct x1f4_datatype_type *, struct x1f4_ejrecord_type *);
extern int x1f4_seek_e4jack
    (const struct x1f4_datatype_type *, const char *, unsigned, int *);
extern int x1f4_stat_e4jack
    (void *, int (*) (void *, const char *, unsigned),
     struct x1f4_ejrecord_type *);

#endif				/* __LIBx1f4_e4jack_H__ */
