/*
 * e4jack.1.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>

#define try_line(deck, c1, c2, c3, c4, c5, c6, c7) \
    (try_rate((deck), (c1), (c2), (c3), (c4), (c5), (c6))		      \
     || *(const unsigned char *) ((deck) + 7) != (c7))

#define try_rate(deck, c1, c2, c3, c4, c5, c6) \
    (try_type((deck), (c1), (c2), (c3))					      \
     || *(const unsigned char *) ((deck) + 4) != (c4)			      \
     || *(const unsigned char *) ((deck) + 5) != (c5)			      \
     || *(const unsigned char *) ((deck) + 6) != (c6))

#define try_type(deck, c1, c2, c3) \
    (*(const unsigned char *) ((deck) + 1) != (c1)			      \
     || *(const unsigned char *) ((deck) + 2) != (c2)			      \
     || *(const unsigned char *) ((deck) + 3) != (c3))

int
x1f4_lock_e4jack(const char *deck, unsigned size, int *type)
{
    int status;

    if (size == 8) {
	int c;

	c = *(const unsigned char *) deck;
	if (c == 0x63) {
	    if (try_line(deck, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c)) {
		status = 1;
	    } else {
		status = 0;

		*type = X1f4_E4_BILL;
	    }
	} else {
	    if (1) {
		status = 1;
	    }
	}
    } else {
	if (size == 7) {
	    int c;

	    c = *(const unsigned char *) deck;
	    if (c == 0x69) {
		if (try_rate(deck, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72)) {
		    status = 1;
		} else {
		    status = 0;

		    *type = X1f4_E4_MODE;
		}
	    } else {
		if (1) {
		    status = 1;
		}
	    }
	} else {
	    if (size != 4) {
		status = 1;
	    } else {
		int c;

		c = *(const unsigned char *) deck;
		if (c == 0x72) {
		    if (try_type(deck, 0x65, 0x61, 0x6c)) {
			status = 1;
		    } else {
			status = 0;

			*type = X1f4_E4_REAL;
		    }
		} else {
		    if (c == 0x74) {
			if (try_type(deck, 0x65, 0x78, 0x74)) {
			    status = 1;
			} else {
			    status = 0;

			    *type = X1f4_E4_TEXT;
			}
		    } else {
			if (c == 0x76) {
			    if (try_type(deck, 0x6f, 0x69, 0x64)) {
				status = 1;
			    } else {
				status = 0;

				*type = X1f4_E4_VOID;
			    }
			} else {
			    if (1) {
				status = 1;
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}
